<?php
// File: klinik-topsis/app/controllers/AdminController.php

class AdminController extends Controller {
    public function __construct() {
        // Cek apakah pengguna sudah login
        if (!isset($_SESSION['user_id'])) {
            $this->redirect('auth/index');
        }
        // Cek apakah pengguna memiliki peran 'admin'
        if ($_SESSION['user_role'] !== 'admin') {
            // Jika bukan admin, bisa redirect ke halaman error atau login
            $this->redirect('auth/logout'); 
        }
    }

    public function index() {
        // Method default, bisa diarahkan ke dashboard
        $this->dashboard();
    }

    public function dashboard() {
    // Memuat model yang dibutuhkan
    $user_model = $this->model('User_model');
    $kriteria_model = $this->model('Kriteria_model');
    $pasien_model = $this->model('Pasien_model'); // 1. Muat model Pasien

    // Mengambil data untuk kartu statistik
    $data = [
        'title' => 'Dashboard Admin',
        'nama_user' => $_SESSION['user_nama'],
        'total_pengguna' => $user_model->countAllUsers(),
        'total_kriteria' => $kriteria_model->countAllKriteria(),
        'total_pasien' => $pasien_model->countAllPasien() // 2. Panggil fungsi dan tambahkan ke data
    ];
    
    $this->view('admin/dashboard', $data);
}
}
