<?php
// File: klinik-topsis/app/controllers/AuthController.php
// Deskripsi: Controller untuk menangani semua logika otentikasi (login, logout).

class AuthController extends Controller {

    /**
     * Menampilkan halaman login.
     * Ini adalah method default untuk controller ini.
     */
    public function index() {
        // Jika pengguna sudah login, langsung redirect ke dashboard yang sesuai
        if (isset($_SESSION['user_id'])) {
            $role = $_SESSION['user_role'];
            if ($role === 'admin') {
                $this->redirect('admin/dashboard');
            } else if ($role === 'bidan') {
                $this->redirect('bidan/dashboard');
            }
        }
        
        // Data untuk dikirim ke view
        $data['title'] = 'Login';
        
        // Tampilkan view login
        $this->view('auth/login', $data);
    }

    /**
     * Memproses data dari form login.
     */
    public function processLogin() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $username = $_POST['username'];
            $password = $_POST['password'];

            // Memuat model pengguna
            $userModel = $this->model('User_model');
            $user = $userModel->getUserByUsername($username);

            // Cek apakah pengguna ditemukan dan password cocok
            if ($user && password_verify($password, $user->password)) {
                // Jika berhasil, buat session
                $_SESSION['user_id'] = $user->id;
                $_SESSION['username'] = $user->username;
                $_SESSION['user_nama'] = $user->nama_lengkap;
                $_SESSION['user_role'] = $user->role;

                // Redirect berdasarkan peran (role)
                if ($user->role == 'admin') {
                    $this->redirect('admin/dashboard');
                } else {
                    $this->redirect('bidan/dashboard');
                }
            } else {
                // Jika gagal, kembali ke halaman login dengan pesan error
                // Kita akan menggunakan session flash message untuk ini
                $_SESSION['login_error'] = 'Username atau password salah.';
                $this->redirect('auth/index');
            }
        } else {
            // Jika diakses langsung tanpa POST, redirect ke halaman login
            $this->redirect('auth/index');
        }
    }

    /**
     * Proses logout pengguna.
     */
    public function logout() {
        // Hancurkan semua data session
        session_unset();
        session_destroy();
        
        // Redirect ke halaman login
        $this->redirect('auth/index');
    }
}
