<?php
// File: klinik-topsis/app/controllers/BidanController.php

class BidanController extends Controller {
    public function __construct() {
        // Cek apakah pengguna sudah login
        if (!isset($_SESSION['user_id'])) {
            $this->redirect('auth/index');
        }
        // Cek apakah pengguna memiliki peran 'bidan'
        if ($_SESSION['user_role'] !== 'bidan') {
            // Jika bukan bidan, bisa redirect ke halaman error atau login
            $this->redirect('auth/logout');
        }
    }

    public function index() {
        $this->dashboard();
    }

    public function dashboard() {
        $id_bidan = $_SESSION['user_id'];
        
        // Memuat semua model yang dibutuhkan
        $pasien_model = $this->model('Pasien_model');
        $jadwal_model = $this->model('Jadwal_model');
        $topsis_model = $this->model('Topsis_model');

        // Mengambil data untuk kartu statistik dan daftar
        $data = [
            'title' => 'Dashboard Bidan',
            'nama_user' => $_SESSION['user_nama'],
            'total_pasien' => $pasien_model->countAllPasienByBidan($id_bidan),
            'jadwal_aktif' => $jadwal_model->countJadwalByStatus($id_bidan, 'dijadwalkan'),
            'kunjungan_selesai' => $jadwal_model->countJadwalByStatus($id_bidan, 'selesai'),
            'top_prioritas' => $topsis_model->getTopPrioritas($id_bidan, 3)
        ];

        $this->view('bidan/dashboard', $data);
    }
}
