<?php
// File: klinik-topsis/app/controllers/HasilController.php

class HasilController extends Controller {

    public function __construct() {
        // Proteksi halaman, hanya bidan yang bisa akses
        if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'bidan') {
            $this->redirect('auth/index');
        }
    }

    public function index() {
        $data['title'] = 'Hasil Prioritas Home Visit';
        $data['nama_user'] = $_SESSION['user_nama'];
        
        // Panggil model untuk melakukan perhitungan
        $topsis_model = $this->model('Topsis_model');
        $hasil_perhitungan = $topsis_model->hitung($_SESSION['user_id']);
        
        // Gabungkan hasil perhitungan ke dalam array data untuk view
        $data = array_merge($data, $hasil_perhitungan);

        $this->view('bidan/hasil/index', $data);
    }
}
