<?php
// File: klinik-topsis/app/controllers/JadwalController.php

class JadwalController extends Controller {
    
    public function __construct() {
        // Proteksi halaman, hanya bidan yang bisa akses
        if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'bidan') {
            $this->redirect('auth/index');
        }
    }

    public function index() {
        $data['title'] = 'Jadwal Kunjungan';
        $data['nama_user'] = $_SESSION['user_nama'];
        
        $jadwal_model = $this->model('Jadwal_model');
        $data['jadwal_list'] = $jadwal_model->getAllJadwalByBidan($_SESSION['user_id']);
        
        // Ambil data pasien untuk dropdown form
        $pasien_model = $this->model('Pasien_model');
        $data['pasien_list'] = $pasien_model->getAllPasienByBidan($_SESSION['user_id']);

        $this->view('bidan/jadwal/index', $data);
    }

    public function tambah() {
        if ($this->model('Jadwal_model')->tambahDataJadwal($_POST) > 0) {
            $_SESSION['flash'] = ['pesan' => 'Berhasil', 'aksi' => 'ditambahkan', 'tipe' => 'success'];
        } else {
            $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'ditambahkan', 'tipe' => 'danger'];
        }
        $this->redirect('jadwal');
    }

    public function getCatatan() {
        // Mengembalikan data catatan dalam format JSON untuk modal
        if (isset($_POST['id_jadwal'])) {
            $catatan = $this->model('Jadwal_model')->getCatatanByJadwalId($_POST['id_jadwal']);
            echo json_encode($catatan);
        }
    }

    public function simpanCatatan() {
        if ($this->model('Jadwal_model')->simpanCatatanKunjungan($_POST) > 0) {
            $_SESSION['flash'] = ['pesan' => 'Berhasil', 'aksi' => 'disimpan', 'tipe' => 'success'];
        } else {
            $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'disimpan', 'tipe' => 'danger'];
        }
        $this->redirect('jadwal');
    }

     public function tandaiSelesai($id_jadwal) {
        if ($this->model('Jadwal_model')->ubahStatusJadwal($id_jadwal, 'selesai') > 0) {
            $_SESSION['flash'] = ['pesan' => 'Berhasil', 'aksi' => 'ditandai selesai', 'tipe' => 'success'];
        } else {
            $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'ditandai selesai', 'tipe' => 'danger'];
        }
        $this->redirect('jadwal');
    }

    public function tandaiBatal($id_jadwal) {
        if ($this->model('Jadwal_model')->ubahStatusJadwal($id_jadwal, 'dibatalkan') > 0) {
            $_SESSION['flash'] = ['pesan' => 'Berhasil', 'aksi' => 'dibatalkan', 'tipe' => 'success'];
        } else {
            $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'dibatalkan', 'tipe' => 'danger'];
        }
        $this->redirect('jadwal');
    }
}
