<?php
// File: klinik-topsis/app/controllers/KriteriaController.php

class KriteriaController extends Controller {

    public function __construct() {
        // Proteksi halaman, hanya admin yang bisa akses
        if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
            $this->redirect('auth/index');
        }
    }

    public function index() {
        $data['title'] = 'Kelola Kriteria';
        $data['nama_user'] = $_SESSION['user_nama'];
        $data['kriteria'] = $this->model('Kriteria_model')->getAllKriteria();

        $this->view('admin/kriteria/index', $data);
    }

    public function tambah() {
        if ($this->model('Kriteria_model')->tambahDataKriteria($_POST) > 0) {
            $_SESSION['flash'] = ['pesan' => 'Berhasil', 'aksi' => 'ditambahkan', 'tipe' => 'success'];
            $this->redirect('kriteria');
        } else {
            $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'ditambahkan', 'tipe' => 'danger'];
            $this->redirect('kriteria');
        }
    }

    public function hapus($id) {
        if ($this->model('Kriteria_model')->hapusDataKriteria($id) > 0) {
            $_SESSION['flash'] = ['pesan' => 'Berhasil', 'aksi' => 'dihapus', 'tipe' => 'success'];
            $this->redirect('kriteria');
        } else {
            $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'dihapus', 'tipe' => 'danger'];
            $this->redirect('kriteria');
        }
    }

    public function getUbah() {
        // Mengembalikan data dalam format JSON untuk di-fetch oleh JavaScript
        echo json_encode($this->model('Kriteria_model')->getKriteriaById($_POST['id']));
    }
    
    public function ubah() {
        if ($this->model('Kriteria_model')->ubahDataKriteria($_POST) > 0) {
            $_SESSION['flash'] = ['pesan' => 'Berhasil', 'aksi' => 'diubah', 'tipe' => 'success'];
            $this->redirect('kriteria');
        } else {
            $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'diubah', 'tipe' => 'danger'];
            $this->redirect('kriteria');
        }
    }
}
