<?php
// File: klinik-topsis/app/controllers/PasienController.php

class PasienController extends Controller {

    public function __construct() {
        // Proteksi halaman, ubah dari 'bidan' ke 'admin'
        if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
            $this->redirect('auth/index');
        }
    }

     public function index() {
        $data['title'] = 'Kelola Data Pasien';
        $data['nama_user'] = $_SESSION['user_nama'];
        
        // Mengambil semua data pasien untuk admin
        $data['pasien'] = $this->model('Pasien_model')->getAllPasien(); // Pastikan fungsi ini sudah dibuat dari langkah sebelumnya

        // --- TAMBAHAN BARU ---
        // Mengambil daftar bidan untuk form tambah/ubah
        $data['bidan_list'] = $this->model('User_model')->getAllBidan();
        
        $this->view('admin/pasien/index', $data);
    }

    public function tambah() {
        if ($this->model('Pasien_model')->tambahDataPasien($_POST) > 0) {
            $_SESSION['flash'] = ['pesan' => 'Berhasil', 'aksi' => 'ditambahkan', 'tipe' => 'success'];
            $this->redirect('pasien');
        } else {
            $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'ditambahkan', 'tipe' => 'danger'];
            $this->redirect('pasien');
        }
    }

    public function hapus($id) {
        if ($this->model('Pasien_model')->hapusDataPasien($id) > 0) {
            $_SESSION['flash'] = ['pesan' => 'Berhasil', 'aksi' => 'dihapus', 'tipe' => 'success'];
            $this->redirect('pasien');
        } else {
            $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'dihapus', 'tipe' => 'danger'];
            $this->redirect('pasien');
        }
    }

    public function getUbah() {
        // Mengembalikan data dalam format JSON untuk di-fetch oleh JavaScript
        echo json_encode($this->model('Pasien_model')->getPasienById($_POST['id']));
    }
    
    public function ubah() {
        if ($this->model('Pasien_model')->ubahDataPasien($_POST) > 0) {
            $_SESSION['flash'] = ['pesan' => 'Berhasil', 'aksi' => 'diubah', 'tipe' => 'success'];
            $this->redirect('pasien');
        } else {
            $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'diubah (tidak ada perubahan data)', 'tipe' => 'info'];
            $this->redirect('pasien');
        }
    }
}
