<?php
// File: klinik-topsis/app/controllers/PenggunaController.php

class PenggunaController extends Controller {

    public function __construct() {
        // Proteksi halaman, hanya admin yang bisa akses
        if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
            $this->redirect('auth/index');
        }
    }

    public function index() {
        $data['title'] = 'Kelola Pengguna';
        $data['nama_user'] = $_SESSION['user_nama'];
        $data['users'] = $this->model('User_model')->getAllUsers();

        $this->view('admin/pengguna/index', $data);
    }

    public function tambah() {
        // Validasi password
        if ($_POST['password'] !== $_POST['confirm_password']) {
            $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'ditambahkan. Password tidak cocok!', 'tipe' => 'danger'];
            $this->redirect('pengguna');
            exit;
        }

        if ($this->model('User_model')->tambahDataUser($_POST) > 0) {
            $_SESSION['flash'] = ['pesan' => 'Berhasil', 'aksi' => 'ditambahkan', 'tipe' => 'success'];
            $this->redirect('pengguna');
        } else {
            $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'ditambahkan', 'tipe' => 'danger'];
            $this->redirect('pengguna');
        }
    }

    public function hapus($id) {
        if ($this->model('User_model')->hapusDataUser($id) > 0) {
            $_SESSION['flash'] = ['pesan' => 'Berhasil', 'aksi' => 'dihapus', 'tipe' => 'success'];
            $this->redirect('pengguna');
        } else {
            $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'dihapus (Admin tidak bisa menghapus diri sendiri)', 'tipe' => 'danger'];
            $this->redirect('pengguna');
        }
    }

    public function getUbah() {
        // Mengembalikan data dalam format JSON untuk di-fetch oleh JavaScript
        echo json_encode($this->model('User_model')->getUserById($_POST['id']));
    }
    
    public function ubah() {
        // Validasi password jika diisi
        if (!empty($_POST['password'])) {
            if ($_POST['password'] !== $_POST['confirm_password']) {
                $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'diubah. Password tidak cocok!', 'tipe' => 'danger'];
                $this->redirect('pengguna');
                exit;
            }
        }

        if ($this->model('User_model')->ubahDataUser($_POST) > 0) {
            $_SESSION['flash'] = ['pesan' => 'Berhasil', 'aksi' => 'diubah', 'tipe' => 'success'];
            $this->redirect('pengguna');
        } else {
            $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'diubah (Tidak ada perubahan data)', 'tipe' => 'info'];
            $this->redirect('pengguna');
        }
    }
}
