<?php
// File: klinik-topsis/app/controllers/PenilaianController.php

class PenilaianController extends Controller {

    public function __construct() {
        // Proteksi halaman, hanya bidan yang bisa akses
        if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'bidan') {
            $this->redirect('auth/index');
        }
    }

    // Menampilkan daftar pasien untuk dinilai
    public function index() {
        $data['title'] = 'Input Penilaian Pasien';
        $data['nama_user'] = $_SESSION['user_nama'];
        $data['pasien'] = $this->model('Pasien_model')->getAllPasienByBidan($_SESSION['user_id']);

        $this->view('bidan/penilaian/index', $data);
    }

    // Menampilkan form penilaian untuk pasien tertentu
    public function form($id_pasien) {
        $data['title'] = 'Form Penilaian';
        $data['nama_user'] = $_SESSION['user_nama'];
        $data['pasien'] = $this->model('Pasien_model')->getPasienById($id_pasien);
        
        // Cek apakah pasien ada dan milik bidan ini
        if (!$data['pasien'] || $data['pasien']->id_bidan != $_SESSION['user_id']) {
            $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'mengakses data pasien', 'tipe' => 'danger'];
            $this->redirect('penilaian');
        }
        
        $data['kriteria_list'] = $this->model('Kriteria_model')->getAllKriteriaWithSub();
        $data['penilaian_terakhir'] = $this->model('Penilaian_model')->getPenilaianTerakhir($id_pasien);

        $this->view('bidan/penilaian/form', $data);
    }

    // Menyimpan data dari form penilaian
    public function simpan() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            if ($this->model('Penilaian_model')->simpanPenilaian($_POST) > 0) {
                $_SESSION['flash'] = ['pesan' => 'Berhasil', 'aksi' => 'disimpan', 'tipe' => 'success'];
                $this->redirect('penilaian');
            } else {
                $_SESSION['flash'] = ['pesan' => 'Gagal', 'aksi' => 'disimpan', 'tipe' => 'danger'];
                $this->redirect('penilaian');
            }
        } else {
            $this->redirect('penilaian');
        }
    }
}
