<?php
// File: klinik-topsis/app/core/App.php
// Deskripsi: Kelas inti yang bertanggung jawab untuk routing (mengarahkan URL ke controller yang tepat).
// Ini adalah "jantung" dari arsitektur MVC kita.

class App {
    // Properti untuk menyimpan controller, method, dan parameter default
    protected $controller = 'AuthController'; // Controller default
    protected $method = 'index';              // Method default
    protected $params = [];                   // Parameter default

    public function __construct() {
        $url = $this->parseURL();

        // --- Proses Controller ---
        // Cek apakah ada file controller yang sesuai dengan nama dari URL.
        // Nama controller di URL kita buat case-insensitive, tapi nama file harus PascalCase.
        if (isset($url[0])) {
            $controllerName = ucfirst(strtolower($url[0])) . 'Controller';
            if (file_exists('../app/controllers/' . $controllerName . '.php')) {
                $this->controller = $controllerName;
                unset($url[0]);
            }
        }

        // Muat controller dan buat instance-nya
        require_once '../app/controllers/' . $this->controller . '.php';
        $this->controller = new $this->controller;

        // --- Proses Method ---
        // Cek apakah ada method yang dikirimkan melalui URL
        if (isset($url[1])) {
            if (method_exists($this->controller, $url[1])) {
                $this->method = $url[1];
                unset($url[1]);
            }
        }

        // --- Proses Params ---
        // Sisa dari URL akan menjadi parameter
        if (!empty($url)) {
            $this->params = array_values($url);
        }

        // --- Jalankan Controller & Method, serta kirimkan Params jika ada ---
        // Ini akan menjalankan method pada objek controller dengan parameter dari URL
        call_user_func_array([$this->controller, $this->method], $this->params);
    }

    /**
     * Mem-parsing URL dari parameter 'url' yang didapat dari .htaccess
     * dan membersihkannya dari karakter aneh.
     * @return array
     */
    public function parseURL() {
        if (isset($_GET['url'])) {
            // Hilangkan slash (/) di akhir URL
            $url = rtrim($_GET['url'], '/');
            // Bersihkan URL dari karakter yang berpotensi berbahaya
            $url = filter_var($url, FILTER_SANITIZE_URL);
            // Pecah URL berdasarkan slash (/) menjadi array
            $url = explode('/', $url);
            return $url;
        }
        return [];
    }
}
