<?php
// File: klinik-topsis/app/core/Controller.php

class Controller {
    public function view($view, $data = []) {
        extract($data);
        $viewPath = '../app/views/' . $view . '.php';
        if (file_exists($viewPath)) {
            require_once $viewPath;
        } else {
            die('View "' . $view . '" tidak ditemukan!');
        }
    }

    public function model($model) {
        $modelPath = '../app/models/' . $model . '.php';
        if (file_exists($modelPath)) {
            require_once $modelPath;
            return new $model();
        } else {
             die('Model "' . $model . '" tidak ditemukan!');
        }
    }

    /**
     * Helper untuk redirect ke URL lain.
     * @param string $url Path tujuan redirect (contoh: 'auth/login').
     */
    public function redirect($url) {
        // PERUBAHAN DI SINI: Menggunakan format URL dengan parameter GET
        $location = BASEURL . '/public/index.php?url=' . $url;
        header('Location: ' . $location);
        exit();
    }
}
