<?php
// File: klinik-topsis/app/init.php
// Deskripsi: File ini adalah gerbang utama untuk memuat semua komponen inti aplikasi (bootstrap).
// public/index.php hanya akan memanggil file ini.

// Pastikan kita memulai sesi di awal jika belum ada.
if (!session_id()) {
    session_start();
}

// 1. Memuat File Konfigurasi / Konstanta
// File ini berisi semua pengaturan penting seperti info database, base URL, dll.
require_once 'core/Constants.php';

// 2. Autoloader
// Fungsi ini akan secara otomatis memuat file class saat class tersebut dipanggil.
// Ini menghilangkan kebutuhan untuk menulis 'require_once' untuk setiap class.
spl_autoload_register(function ($className) {
    // Tentukan path ke direktori kelas
    $paths = [
        'core/',
        'controllers/',
        'models/'
    ];

    foreach ($paths as $path) {
        // Gunakan __DIR__ untuk path absolut dari file ini
        $file = __DIR__ . '/' . $path . $className . '.php';
        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
});
