<?php
// File: klinik-topsis/app/models/Jadwal_model.php

class Jadwal_model {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance();
    }

    /**
     * Mengambil semua jadwal milik bidan yang login, di-join dengan nama pasien.
     * @param int $id_bidan
     * @return array
     */
    public function getAllJadwalByBidan($id_bidan) {
        $this->db->query("
            SELECT 
                j.id, 
                j.id_pasien, 
                p.nama_ibu, 
                j.tanggal_kunjungan, 
                j.status 
            FROM jadwal_kunjungan j
            JOIN pasien p ON j.id_pasien = p.id
            WHERE j.id_bidan = :id_bidan
            ORDER BY j.tanggal_kunjungan DESC
        ");
        $this->db->bind('id_bidan', $id_bidan);
        return $this->db->resultSet();
    }

    /**
     * Menambah jadwal kunjungan baru.
     * @param array $data
     * @return int
     */
    public function tambahDataJadwal($data) {
        $query = "INSERT INTO jadwal_kunjungan (id_pasien, id_bidan, tanggal_kunjungan)
                  VALUES (:id_pasien, :id_bidan, :tanggal_kunjungan)";
        $this->db->query($query);
        $this->db->bind('id_pasien', $data['id_pasien']);
        $this->db->bind('id_bidan', $_SESSION['user_id']);
        $this->db->bind('tanggal_kunjungan', $data['tanggal_kunjungan']);
        
        $this->db->execute();
        return $this->db->rowCount();
    }

    /**
     * Mengubah status jadwal (misal: dari 'dijadwalkan' menjadi 'selesai').
     * @param int $id ID jadwal
     * @param string $status Status baru
     * @return int
     */
    public function ubahStatusJadwal($id, $status) {
        $query = "UPDATE jadwal_kunjungan SET status = :status WHERE id = :id";
        $this->db->query($query);
        $this->db->bind('status', $status);
        $this->db->bind('id', $id);

        $this->db->execute();
        return $this->db->rowCount();
    }

    /**
     * Mengambil catatan kunjungan berdasarkan ID jadwal.
     * @param int $id_jadwal_kunjungan
     * @return object|false
     */
    public function getCatatanByJadwalId($id_jadwal_kunjungan) {
        $this->db->query("SELECT * FROM catatan_kunjungan WHERE id_jadwal_kunjungan = :id");
        $this->db->bind('id', $id_jadwal_kunjungan);
        return $this->db->single();
    }

    /**
     * Menyimpan atau memperbarui catatan kunjungan.
     * @param array $data
     * @return int
     */
    public function simpanCatatanKunjungan($data) {
        $id_jadwal = $data['id_jadwal_kunjungan'];
        $catatan = $this->getCatatanByJadwalId($id_jadwal);

        if ($catatan) {
            // Jika catatan sudah ada, UPDATE
            $query = "UPDATE catatan_kunjungan SET 
                        catatan_pemeriksaan = :catatan_pemeriksaan,
                        tindakan_diberikan = :tindakan_diberikan,
                        edukasi = :edukasi
                      WHERE id_jadwal_kunjungan = :id_jadwal_kunjungan";
        } else {
            // Jika belum ada, INSERT
            $query = "INSERT INTO catatan_kunjungan (id_jadwal_kunjungan, catatan_pemeriksaan, tindakan_diberikan, edukasi)
                      VALUES (:id_jadwal_kunjungan, :catatan_pemeriksaan, :tindakan_diberikan, :edukasi)";
        }

        $this->db->query($query);
        $this->db->bind('id_jadwal_kunjungan', $id_jadwal);
        $this->db->bind('catatan_pemeriksaan', $data['catatan_pemeriksaan']);
        $this->db->bind('tindakan_diberikan', $data['tindakan_diberikan']);
        $this->db->bind('edukasi', $data['edukasi']);

        $this->db->execute();

        // Setelah simpan catatan, tandai jadwal sebagai 'selesai'
        if ($this->db->rowCount() > 0) {
            return $this->ubahStatusJadwal($id_jadwal, 'selesai');
        }
        return 0;
    }
    
    public function countJadwalByStatus($id_bidan, $status) {
        $this->db->query('SELECT COUNT(*) as total FROM jadwal_kunjungan WHERE id_bidan = :id_bidan AND status = :status');
        $this->db->bind(':id_bidan', $id_bidan);
        $this->db->bind(':status', $status);
        return $this->db->single()->total;
    }
}
