<?php
// File: klinik-topsis/app/models/Kriteria_model.php

class Kriteria_model {
    private $db;
    private $table = 'kriteria';

    public function __construct() {
        $this->db = Database::getInstance();
    }

    public function getAllKriteria() {
        $this->db->query('SELECT * FROM ' . $this->table . ' ORDER BY kode_kriteria ASC');
        return $this->db->resultSet();
    }
    
    /**
     * FUNGSI BARU: Mengambil semua kriteria beserta sub-kriterianya.
     * Hasilnya akan di-grouping berdasarkan kriteria.
     * @return array
     */
    public function getAllKriteriaWithSub() {
        $this->db->query("
            SELECT 
                k.id as id_kriteria, 
                k.kode_kriteria, 
                k.nama_kriteria,
                sk.id as id_sub_kriteria,
                sk.deskripsi,
                sk.nilai
            FROM kriteria k
            JOIN sub_kriteria sk ON k.id = sk.id_kriteria
            ORDER BY k.kode_kriteria, sk.nilai ASC
        ");
        
        $results = $this->db->resultSet();
        
        // Grouping hasil berdasarkan kriteria
        $grouped = [];
        foreach ($results as $row) {
            $grouped[$row->id_kriteria]['id_kriteria'] = $row->id_kriteria;
            $grouped[$row->id_kriteria]['kode_kriteria'] = $row->kode_kriteria;
            $grouped[$row->id_kriteria]['nama_kriteria'] = $row->nama_kriteria;
            $grouped[$row->id_kriteria]['sub_kriteria'][] = [
                'id_sub_kriteria' => $row->id_sub_kriteria,
                'deskripsi' => $row->deskripsi,
                'nilai' => $row->nilai
            ];
        }
        return $grouped;
    }


    public function getKriteriaById($id) {
        $this->db->query('SELECT * FROM ' . $this->table . ' WHERE id=:id');
        $this->db->bind('id', $id);
        return $this->db->single();
    }

    public function tambahDataKriteria($data) {
        $query = "INSERT INTO kriteria (kode_kriteria, nama_kriteria, bobot, tipe) 
                  VALUES (:kode_kriteria, :nama_kriteria, :bobot, :tipe)";
        
        $this->db->query($query);
        $this->db->bind('kode_kriteria', $data['kode_kriteria']);
        $this->db->bind('nama_kriteria', $data['nama_kriteria']);
        $this->db->bind('bobot', $data['bobot']);
        $this->db->bind('tipe', $data['tipe']);

        $this->db->execute();
        return $this->db->rowCount();
    }

    public function hapusDataKriteria($id) {
        $query = "DELETE FROM kriteria WHERE id = :id";
        $this->db->query($query);
        $this->db->bind('id', $id);

        $this->db->execute();
        return $this->db->rowCount();
    }

    public function ubahDataKriteria($data) {
        $query = "UPDATE kriteria SET
                    kode_kriteria = :kode_kriteria,
                    nama_kriteria = :nama_kriteria,
                    bobot = :bobot,
                    tipe = :tipe
                  WHERE id = :id";
        
        $this->db->query($query);
        $this->db->bind('kode_kriteria', $data['kode_kriteria']);
        $this->db->bind('nama_kriteria', $data['nama_kriteria']);
        $this->db->bind('bobot', $data['bobot']);
        $this->db->bind('tipe', $data['tipe']);
        $this->db->bind('id', $data['id']);

        $this->db->execute();
        return $this->db->rowCount();
    }
    
    public function countAllKriteria() {
        $this->db->query('SELECT COUNT(*) as total FROM ' . $this->table);
        return $this->db->single()->total;
    }
}
