<?php
// File: klinik-topsis/app/models/Pasien_model.php

class Pasien_model {
    private $db;
    private $table = 'pasien';

    public function __construct() {
        $this->db = Database::getInstance();
    }

    /**
     * FUNGSI BARU: Mengambil semua data pasien untuk admin.
     * @return array
     */
    public function getAllPasien() {
        $this->db->query('SELECT p.*, u.nama_lengkap as nama_bidan FROM ' . $this->table . ' p JOIN users u ON p.id_bidan = u.id ORDER BY p.nama_ibu ASC');
        return $this->db->resultSet();
    }

    /**
     * Mengambil semua data pasien yang ditangani oleh bidan yang sedang login.
     * @param int $id_bidan ID dari bidan yang login.
     * @return array
     */
    public function getAllPasienByBidan($id_bidan) {
        // Query untuk mengambil data pasien khusus untuk bidan yang login
        $this->db->query('SELECT * FROM ' . $this->table . ' WHERE id_bidan = :id_bidan ORDER BY nama_ibu ASC');
        $this->db->bind(':id_bidan', $id_bidan);
        return $this->db->resultSet();
    }

    /**
     * Mengambil satu data pasien berdasarkan ID.
     * @param int $id ID Pasien.
     * @return object
     */
    public function getPasienById($id) {
        $this->db->query('SELECT * FROM ' . $this->table . ' WHERE id=:id');
        $this->db->bind('id', $id);
        return $this->db->single();
    }

    /**
     * Menambah data pasien baru.
     * @param array $data Data dari form.
     * @return int
     */
    public function tambahDataPasien($data) {
        $query = "INSERT INTO pasien (id_bidan, nama_ibu, nik, alamat, no_telepon, tanggal_lahir, usia_kehamilan_minggu) 
                  VALUES (:id_bidan, :nama_ibu, :nik, :alamat, :no_telepon, :tanggal_lahir, :usia_kehamilan_minggu)";
        
        $this->db->query($query);
        
        // --- PERUBAHAN DI SINI ---
        // 'id_bidan' sekarang diambil dari data form, bukan session.
        $this->db->bind('id_bidan', $data['id_bidan']); 
        
        $this->db->bind('nama_ibu', $data['nama_ibu']);
        $this->db->bind('nik', $data['nik']);
        $this->db->bind('alamat', $data['alamat']);
        $this->db->bind('no_telepon', $data['no_telepon']);
        $this->db->bind('tanggal_lahir', $data['tanggal_lahir']);
        $this->db->bind('usia_kehamilan_minggu', $data['usia_kehamilan_minggu']);

        $this->db->execute();
        return $this->db->rowCount();
    }

    /**
     * Menghapus data pasien.
     * @param int $id ID pasien.
     * @return int
     */
    public function hapusDataPasien($id) {
        $query = "DELETE FROM pasien WHERE id = :id";
        $this->db->query($query);
        $this->db->bind('id', $id);

        $this->db->execute();
        return $this->db->rowCount();
    }

    /**
     * Mengubah data pasien.
     * @param array $data Data dari form.
     * @return int
     */
    public function ubahDataPasien($data) {
        $query = "UPDATE pasien SET
                    nama_ibu = :nama_ibu,
                    nik = :nik,
                    alamat = :alamat,
                    no_telepon = :no_telepon,
                    tanggal_lahir = :tanggal_lahir,
                    usia_kehamilan_minggu = :usia_kehamilan_minggu
                  WHERE id = :id";
        
        $this->db->query($query);
        $this->db->bind('nama_ibu', $data['nama_ibu']);
        $this->db->bind('nik', $data['nik']);
        $this->db->bind('alamat', $data['alamat']);
        $this->db->bind('no_telepon', $data['no_telepon']);
        $this->db->bind('tanggal_lahir', $data['tanggal_lahir']);
        $this->db->bind('usia_kehamilan_minggu', $data['usia_kehamilan_minggu']);
        $this->db->bind('id', $data['id']);

        $this->db->execute();
        return $this->db->rowCount();
    }
    
    public function countAllPasienByBidan($id_bidan) {
        $this->db->query('SELECT COUNT(*) as total FROM ' . $this->table . ' WHERE id_bidan = :id_bidan');
        $this->db->bind(':id_bidan', $id_bidan);
        return $this->db->single()->total;
    }
    public function getJumlahPasien() {
    $this->db->query('SELECT id FROM ' . $this->table);
    $this->db->execute();
    return $this->db->rowCount();
}
 public function countAllPasien() {
        $this->db->query('SELECT id FROM ' . $this->table);
        $this->db->execute();
        return $this->db->rowCount();
    }

}
