<?php
// File: klinik-topsis/app/models/Penilaian_model.php

class Penilaian_model {
    private $db;
    private $table = 'penilaian';

    public function __construct() {
        $this->db = Database::getInstance();
    }

    /**
     * Menyimpan data penilaian ke database.
     * @param array $data Data dari form penilaian.
     * @return int Jumlah baris yang berhasil ditambahkan.
     */
    public function simpanPenilaian($data) {
        $id_pasien = $data['id_pasien'];
        $periode = date('Y-m-d'); // Menggunakan tanggal hari ini sebagai periode

        // Hapus data penilaian lama untuk pasien ini pada periode ini (jika ada)
        $this->db->query("DELETE FROM " . $this->table . " WHERE id_pasien = :id_pasien AND periode_penilaian = :periode");
        $this->db->bind('id_pasien', $id_pasien);
        $this->db->bind('periode', $periode);
        $this->db->execute();
        
        $total_rows = 0;
        // Looping untuk menyimpan setiap nilai kriteria
        foreach ($data['penilaian'] as $id_kriteria => $id_sub_kriteria) {
            // Ambil nilai dari sub_kriteria
            $this->db->query("SELECT nilai FROM sub_kriteria WHERE id = :id_sub");
            $this->db->bind(':id_sub', $id_sub_kriteria);
            $sub_kriteria = $this->db->single();
            $nilai = $sub_kriteria ? $sub_kriteria->nilai : 0;

            $query = "INSERT INTO penilaian (id_pasien, id_kriteria, id_sub_kriteria, nilai, periode_penilaian)
                      VALUES (:id_pasien, :id_kriteria, :id_sub_kriteria, :nilai, :periode)";
            
            $this->db->query($query);
            $this->db->bind('id_pasien', $id_pasien);
            $this->db->bind('id_kriteria', $id_kriteria);
            $this->db->bind('id_sub_kriteria', $id_sub_kriteria);
            $this->db->bind('nilai', $nilai);
            $this->db->bind('periode', $periode);
            $this->db->execute();
            $total_rows += $this->db->rowCount();
        }

        return $total_rows;
    }

    /**
     * Mengambil data penilaian terakhir seorang pasien untuk ditampilkan di form.
     * @param int $id_pasien
     * @return array
     */
    public function getPenilaianTerakhir($id_pasien) {
        $this->db->query("
            SELECT id_kriteria, id_sub_kriteria 
            FROM penilaian 
            WHERE id_pasien = :id_pasien 
            AND periode_penilaian = (SELECT MAX(periode_penilaian) FROM penilaian WHERE id_pasien = :id_pasien_inner)
        ");
        $this->db->bind(':id_pasien', $id_pasien);
        $this->db->bind(':id_pasien_inner', $id_pasien);
        
        $results = $this->db->resultSet();
        $penilaian = [];
        foreach ($results as $row) {
            $penilaian[$row->id_kriteria] = $row->id_sub_kriteria;
        }
        return $penilaian;
    }
}
