<?php
// File: klinik-topsis/app/models/User_model.php
// Deskripsi: Model untuk mengelola data pengguna (interaksi dengan tabel 'users').

class User_model {
    private $db;
    private $table = 'users';

    public function __construct() {
        // Menggunakan kelas Database Singleton untuk mendapatkan koneksi
        $this->db = Database::getInstance();
    }

    /**
     * Mengambil data pengguna berdasarkan username.
     * @param string $username
     * @return object|false Data pengguna jika ditemukan, atau false jika tidak.
     */
    public function getUserByUsername($username) {
        // Menyiapkan query untuk mencegah SQL Injection
        $this->db->query('SELECT * FROM ' . $this->table . ' WHERE username = :username');
        
        // Binding data
        $this->db->bind(':username', $username);
        
        // Eksekusi dan kembalikan satu baris hasil
        return $this->db->single();
    }

    /**
     * Mengambil semua data pengguna.
     * @return array
     */
    public function getAllUsers() {
        $this->db->query('SELECT id, nama_lengkap, username, role FROM ' . $this->table);
        return $this->db->resultSet();
    }

    /**
     * Mengambil data pengguna berdasarkan ID.
     * @param int $id
     * @return object|false Data pengguna jika ditemukan, atau false jika tidak.
     */
    public function getUserById($id) {
        $this->db->query('SELECT id, nama_lengkap, username, role FROM ' . $this->table . ' WHERE id = :id');
        $this->db->bind(':id', $id);
        return $this->db->single();
    }

    /**
     * Menambah data pengguna baru.
     * @param array $data Data dari form.
     * @return int Jumlah baris yang terpengaruh.
     */
    public function tambahDataUser($data) {
        $query = "INSERT INTO users (nama_lengkap, username, password, role) 
                  VALUES (:nama_lengkap, :username, :password, :role)";
        
        $this->db->query($query);
        $this->db->bind('nama_lengkap', $data['nama_lengkap']);
        $this->db->bind('username', $data['username']);
        // Hash password sebelum disimpan ke database
        $this->db->bind('password', password_hash($data['password'], PASSWORD_DEFAULT));
        $this->db->bind('role', $data['role']);

        $this->db->execute();
        return $this->db->rowCount();
    }

    /**
     * Menghapus data pengguna.
     * @param int $id ID pengguna yang akan dihapus.
     * @return int Jumlah baris yang terpengaruh.
     */
    public function hapusDataUser($id) {
        // Pastikan admin tidak bisa menghapus dirinya sendiri
        if ($id == $_SESSION['user_id']) {
            return 0;
        }
        $query = "DELETE FROM users WHERE id = :id";
        $this->db->query($query);
        $this->db->bind('id', $id);

        $this->db->execute();
        return $this->db->rowCount();
    }

    /**
     * Mengubah data pengguna.
     * @param array $data Data dari form.
     * @return int Jumlah baris yang terpengaruh.
     */
    public function ubahDataUser($data) {
        // Cek apakah password diisi atau tidak
        if (!empty($data['password'])) {
            // Jika password diisi, update password
            $query = "UPDATE users SET
                        nama_lengkap = :nama_lengkap,
                        username = :username,
                        password = :password,
                        role = :role
                      WHERE id = :id";
            $this->db->query($query);
            $this->db->bind('password', password_hash($data['password'], PASSWORD_DEFAULT));
        } else {
            // Jika password kosong, jangan update password
            $query = "UPDATE users SET
                        nama_lengkap = :nama_lengkap,
                        username = :username,
                        role = :role
                      WHERE id = :id";
            $this->db->query($query);
        }
        
        $this->db->bind('nama_lengkap', $data['nama_lengkap']);
        $this->db->bind('username', $data['username']);
        $this->db->bind('role', $data['role']);
        $this->db->bind('id', $data['id']);

        $this->db->execute();
        return $this->db->rowCount();
    }
    
    // FUNGSI BARU UNTUK DASHBOARD
    public function countAllUsers() {
        $this->db->query('SELECT COUNT(*) as total FROM ' . $this->table);
        return $this->db->single()->total;
    }
    
    public function getAllBidan() {
        $this->db->query('SELECT id, nama_lengkap FROM ' . $this->table . ' WHERE role = :role ORDER BY nama_lengkap ASC');
        $this->db->bind(':role', 'bidan');
        return $this->db->resultSet();
    }
}
