<?php 
$this->view('layouts/header', $data); 
?>

<nav class="bg-gray-800" x-data="{ isOpen: false }">
    <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
      <div class="flex h-16 items-center justify-between">
        <div class="flex items-center">
          <div class="flex-shrink-0">
            <svg class="h-8 w-8 text-indigo-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75l3 3m0 0l3-3m-3 3v-7.5M21 12a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
          </div>
          <div class="hidden md:block">
            <div class="ml-10 flex items-baseline space-x-4">
              <a href="<?= BASEURL; ?>/public/index.php?url=admin/dashboard" class="bg-gray-900 text-white rounded-md px-3 py-2 text-sm font-medium" aria-current="page">Dashboard</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=pasien" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Kelola Pasien</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=kriteria" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Kelola Kriteria</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=pengguna" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Kelola Pengguna</a>
            </div>
          </div>
        </div>
        <div class="hidden md:block">
            <div class="ml-4 flex items-center md:ml-6">
                <span class="text-gray-400 text-sm mr-4">Selamat datang, <?= htmlspecialchars($data['nama_user']); ?></span>
                <a href="<?= BASEURL; ?>/public/index.php?url=auth/logout" class="rounded-full bg-red-600 p-1 text-white hover:bg-red-500 focus:outline-none"><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75" /></svg></a>
            </div>
        </div>
        <div class="-mr-2 flex md:hidden">
          <button @click="isOpen = !isOpen" type="button" class="inline-flex items-center justify-center rounded-md bg-gray-800 p-2 text-gray-400 hover:bg-gray-700 hover:text-white focus:outline-none focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-gray-800"><span class="sr-only">Buka menu</span><svg :class="{'hidden': isOpen, 'block': !isOpen }" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" /></svg><svg :class="{'block': isOpen, 'hidden': !isOpen }" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" /></svg></button>
        </div>
      </div>
    </div>
    <div x-show="isOpen" class="md:hidden" id="mobile-menu">
      <div class="space-y-1 px-2 pb-3 pt-2 sm:px-3">
        <a href="<?= BASEURL; ?>/public/index.php?url=admin/dashboard" class="bg-gray-900 text-white block rounded-md px-3 py-2 text-base font-medium" aria-current="page">Dashboard</a>
        <a href="<?= BASEURL; ?>/public/index.php?url=pasien" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Kelola Pasien</a>
        <a href="<?= BASEURL; ?>/public/index.php?url=kriteria" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Kelola Kriteria</a>
        <a href="<?= BASEURL; ?>/public/index.php?url=pengguna" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Kelola Pengguna</a>
      </div>
       <div class="border-t border-gray-700 pb-3 pt-4">
        <div class="flex items-center px-5">
            <div class="flex-shrink-0"><span class="text-gray-400 text-sm">Selamat datang, <?= htmlspecialchars($data['nama_user']); ?></span></div>
            <a href="<?= BASEURL; ?>/public/index.php?url=auth/logout" class="ml-auto flex-shrink-0 rounded-full bg-red-600 p-1 text-white hover:bg-red-500"><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75" /></svg></a>
        </div>
      </div>
    </div>
</nav>

<div class="relative bg-gray-800 pb-32">
    <div class="absolute inset-0">
        <img class="h-full w-full object-cover" src="https://images.unsplash.com/photo-1521737604893-d14cc237f11d?q=80&w=2084&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D" alt="Ilustrasi Kantor">
        <div class="absolute inset-0 bg-gray-600 mix-blend-multiply" aria-hidden="true"></div>
    </div>
    <div class="relative mx-auto max-w-7xl py-12 px-4 sm:px-6 lg:px-8 text-center">
        <h1 class="text-4xl font-bold tracking-tight text-white md:text-5xl lg:text-6xl">Halo, Administrator!</h1>
        <p class="mt-6 max-w-3xl mx-auto text-xl text-indigo-100">Selamat datang di panel kontrol sistem. Anda dapat mengelola aturan dan pengguna dari sini.</p>
    </div>
</div>

<main class="-mt-32">
    <div class="mx-auto max-w-7xl px-4 pb-12 sm:px-6 lg:px-8">
      <div class="rounded-lg bg-white px-5 py-6 shadow sm:px-6">
        <h3 class="text-base font-semibold leading-6 text-gray-900">Ringkasan Sistem</h3>
        
        <dl class="mt-5 grid grid-cols-1 gap-5 sm:grid-cols-3">
            
          <div class="relative overflow-hidden rounded-lg bg-white px-4 pb-12 pt-5 shadow sm:px-6 sm:pt-6">
            <dt>
                <div class="absolute rounded-md bg-indigo-500 p-3">
                    <svg class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.501 20.118a7.5 7.5 0 0114.998 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.499-1.632z" /></svg>
                </div>
                <p class="ml-16 truncate text-sm font-medium text-gray-500">Total Pasien</p>
            </dt>
            <dd class="ml-16 flex items-baseline pb-6 sm:pb-7">
                <p class="text-2xl font-semibold text-gray-900"><?= $data['total_pasien']; ?></p>
                <div class="absolute inset-x-0 bottom-0 bg-gray-50 px-4 py-4 sm:px-6">
                    <div class="text-sm"><a href="<?= BASEURL; ?>/public/index.php?url=pasien" class="font-medium text-indigo-600 hover:text-indigo-500">Lihat semua</a></div>
                </div>
            </dd>
          </div>

          <div class="relative overflow-hidden rounded-lg bg-white px-4 pb-12 pt-5 shadow sm:px-6 sm:pt-6">
            <dt>
                <div class="absolute rounded-md bg-indigo-500 p-3">
                    <svg class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="M18 18.72a9.094 9.094 0 003.741-.479 3 3 0 00-4.682-2.72m-7.289 2.72a3 3 0 01-4.682-2.72 9.094 9.094 0 013.741-.479m7.289 2.72v-4.286a3.75 3.75 0 00-7.5 0v4.286m7.5 0a9.094 9.094 0 003.741 2.247 3 3 0 01-4.682 2.72m-7.289-2.247a3 3 0 00-4.682 2.72 9.094 9.094 0 003.741 2.247M12 10.5h.008v.008H12v-.008z" /></svg>
                </div>
                <p class="ml-16 truncate text-sm font-medium text-gray-500">Total Pengguna</p>
            </dt>
            <dd class="ml-16 flex items-baseline pb-6 sm:pb-7">
                <p class="text-2xl font-semibold text-gray-900"><?= $data['total_pengguna']; ?></p>
                <div class="absolute inset-x-0 bottom-0 bg-gray-50 px-4 py-4 sm:px-6">
                    <div class="text-sm"><a href="<?= BASEURL; ?>/public/index.php?url=pengguna" class="font-medium text-indigo-600 hover:text-indigo-500">Lihat semua</a></div>
                </div>
            </dd>
          </div>

          <div class="relative overflow-hidden rounded-lg bg-white px-4 pb-12 pt-5 shadow sm:px-6 sm:pt-6">
            <dt>
                <div class="absolute rounded-md bg-indigo-500 p-3">
                    <svg class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="M9.594 3.94c.09-.542.56-1.007 1.11-.95.542.057 1.007.56 1.11.95l.121.733c.42.25.82.569 1.18.94l.582-.265c.55-.25.956.223.77.714l-.623.972c.28.36.52.75.7 1.18l.972.623c.491.186.25.77-.25.956l.582.265c-.24.58-.569.98-.94 1.18l-.265.582c-.25.55.223.956.714.77l.972-.623c.36.28.75.52 1.18.7l.623.972c.186.491-.25.77-.956.25l-.582-.265c-.58.24-.98.569-1.18.94l-.733.121c-.542.09-.956-.56-1.11-.95l-.121-.733c-.42-.25-.82-.569-1.18-.94l-.582.265c-.55-.25-.956-.223-.77-.714l.623-.972c-.28-.36-.52-.75-.7-1.18l-.972-.623c-.491-.186-.25-.77.25-.956l.582.265c.24-.58.569.98.94-1.18l.265-.582c.25-.55.956-.223.714-.77l-.972.623c-.36-.28-.75-.52-1.18-.7l-.623-.972c-.186-.491.25-.77.956-.25l.582.265c.58-.24.98-.569 1.18-.94l.733-.121zM12 15a3 3 0 100-6 3 3 0 000 6z" /></svg>
                </div>
                <p class="ml-16 truncate text-sm font-medium text-gray-500">Total Kriteria</p>
            </dt>
            <dd class="ml-16 flex items-baseline pb-6 sm:pb-7">
                <p class="text-2xl font-semibold text-gray-900"><?= $data['total_kriteria']; ?></p>
                <div class="absolute inset-x-0 bottom-0 bg-gray-50 px-4 py-4 sm:px-6">
                    <div class="text-sm"><a href="<?= BASEURL; ?>/public/index.php?url=kriteria" class="font-medium text-indigo-600 hover:text-indigo-500">Lihat semua</a></div>
                </div>
            </dd>
          </div>
        </dl>
        
        <div class="mt-8">
            <h3 class="text-base font-semibold leading-6 text-gray-900">Aksi Cepat</h3>
            <div class="mt-5 grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-3">
                <a href="<?= BASEURL; ?>/public/index.php?url=pasien" class="flex items-center space-x-3 rounded-lg border border-gray-300 bg-white px-6 py-5 shadow-sm hover:border-gray-400 focus-within:ring-2 focus-within:ring-indigo-500 focus-within:ring-offset-2">
                    <span class="inline-flex rounded-lg bg-green-50 p-3 text-green-700 ring-4 ring-white"><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.501 20.118a7.5 7.5 0 0114.998 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.499-1.632z" /></svg></span>
                    <div class="min-w-0 flex-1"><p class="text-sm font-semibold text-gray-900">Kelola Data Pasien</p><p class="text-sm text-gray-500">Lihat dan kelola semua data pasien.</p></div>
                </a>
                <a href="<?= BASEURL; ?>/public/index.php?url=pengguna" class="flex items-center space-x-3 rounded-lg border border-gray-300 bg-white px-6 py-5 shadow-sm hover:border-gray-400 focus-within:ring-2 focus-within:ring-indigo-500 focus-within:ring-offset-2">
                    <span class="inline-flex rounded-lg bg-purple-50 p-3 text-purple-700 ring-4 ring-white"><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M15 19.128a9.38 9.38 0 002.625.372 9.337 9.337 0 004.121-.952 4.125 4.125 0 00-7.533-2.493M15 19.128v-.003c0-1.113-.285-2.16-.786-3.07M15 19.128v.106A12.318 12.318 0 018.624 21c-2.331 0-4.512-.645-6.374-1.766l-.001-.109a6.375 6.375 0 0111.964-4.67c.12-.318.239-.645.354-.974" /></svg></span>
                    <div class="min-w-0 flex-1"><p class="text-sm font-semibold text-gray-900">Kelola Pengguna</p><p class="text-sm text-gray-500">Tambah atau ubah akun Bidan.</p></div>
                </a>
                 <a href="<?= BASEURL; ?>/public/index.php?url=kriteria" class="flex items-center space-x-3 rounded-lg border border-gray-300 bg-white px-6 py-5 shadow-sm hover:border-gray-400 focus-within:ring-2 focus-within:ring-indigo-500 focus-within:ring-offset-2">
                    <span class="inline-flex rounded-lg bg-blue-50 p-3 text-blue-700 ring-4 ring-white"><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M9.594 3.94c.09-.542.56-1.007 1.11-.95.542.057 1.007.56 1.11.95l.121.733c.42.25.82.569 1.18.94l.582-.265c.55-.25.956.223.77.714l-.623.972c.28.36.52.75.7 1.18l.972.623c.491.186.25.77-.25.956l.582.265c-.24.58-.569.98-.94 1.18l-.265.582c-.25.55.223.956.714.77l.972-.623c.36.28.75.52 1.18.7l.623.972c.186.491-.25.77-.956.25l-.582-.265c-.58.24-.98.569-1.18.94l-.733.121c-.542.09-.956-.56-1.11-.95l-.121-.733c-.42-.25-.82-.569-1.18-.94l-.582.265c-.55-.25-.956-.223-.77-.714l.623-.972c-.28-.36-.52-.75-.7-1.18l-.972-.623c-.491-.186-.25-.77.25-.956l.582.265c.24-.58.569.98.94-1.18l.265-.582c.25-.55.956-.223.714-.77l-.972.623c-.36-.28-.75-.52-1.18-.7l-.623-.972c-.186-.491.25-.77.956-.25l.582.265c.58-.24.98-.569 1.18-.94l.733-.121zM12 15a3 3 0 100-6 3 3 0 000 6z" /></svg></span>
                    <div class="min-w-0 flex-1"><p class="text-sm font-semibold text-gray-900">Kelola Kriteria</p><p class="text-sm text-gray-500">Atur bobot dan tipe kriteria TOPSIS.</p></div>
                </a>
            </div>
        </div>
      </div>
    </div>
</main>

<script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
<?php 
$this->view('layouts/footer'); 
?>