<?php 
$this->view('layouts/header', $data); 
?>
<style>
  @media (max-width: 767px) {
    .responsive-table thead {display: none;}
    .responsive-table tr {display: block; margin-bottom: 1rem; border-radius: 0.5rem; overflow: hidden; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);}
    .responsive-table td {display: block; text-align: right; padding-left: 50%; position: relative; border-bottom: 1px solid #edf2f7;}
    .responsive-table td::before {content: attr(data-label); position: absolute; left: 0.75rem; font-weight: 600; text-align: left;}
    .responsive-table td:last-child {border-bottom: 0;}
    .responsive-table .aksi-sel {padding-left: 0; text-align: center; padding-top: 0.75rem; padding-bottom: 0.75rem; background-color: #f9fafb;}
    .responsive-table .aksi-sel::before {content: '';}
  }
</style>
<!-- Navigasi Admin -->
<nav class="bg-gray-800" x-data="{ isOpen: false }">
    <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
      <div class="flex h-16 items-center justify-between">
        <div class="flex items-center">
          <div class="flex-shrink-0">
            <svg class="h-8 w-8 text-indigo-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75l3 3m0 0l3-3m-3 3v-7.5M21 12a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
          </div>
          <div class="hidden md:block">
            <div class="ml-10 flex items-baseline space-x-4">
              <a href="<?= BASEURL; ?>/public/index.php?url=admin/dashboard" class="bg-gray-900 text-white rounded-md px-3 py-2 text-sm font-medium" aria-current="page">Dashboard</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=pasien" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Kelola Pasien</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=kriteria" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Kelola Kriteria</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=pengguna" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Kelola Pengguna</a>
            </div>
          </div>
        </div>
        <div class="hidden md:block">
            <div class="ml-4 flex items-center md:ml-6">
                <span class="text-gray-400 text-sm mr-4">Selamat datang, <?= htmlspecialchars($data['nama_user']); ?></span>
                <a href="<?= BASEURL; ?>/public/index.php?url=auth/logout" class="rounded-full bg-red-600 p-1 text-white hover:bg-red-500 focus:outline-none"><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75" /></svg></a>
            </div>
        </div>
        <div class="-mr-2 flex md:hidden">
          <button @click="isOpen = !isOpen" type="button" class="inline-flex items-center justify-center rounded-md bg-gray-800 p-2 text-gray-400 hover:bg-gray-700 hover:text-white focus:outline-none focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-gray-800"><span class="sr-only">Buka menu</span><svg :class="{'hidden': isOpen, 'block': !isOpen }" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" /></svg><svg :class="{'block': isOpen, 'hidden': !isOpen }" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" /></svg></button>
        </div>
      </div>
    </div>
    <div x-show="isOpen" class="md:hidden" id="mobile-menu">
      <div class="space-y-1 px-2 pb-3 pt-2 sm:px-3">
        <a href="<?= BASEURL; ?>/public/index.php?url=admin/dashboard" class="bg-gray-900 text-white rounded-md px-3 py-2 text-sm font-medium" aria-current="page">Dashboard</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=pasien" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Kelola Pasien</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=kriteria" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Kelola Kriteria</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=pengguna" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Kelola Pengguna</a>
      </div>
       <div class="border-t border-gray-700 pb-3 pt-4">
        <div class="flex items-center px-5">
            <div class="flex-shrink-0"><span class="text-gray-400 text-sm">Selamat datang, <?= htmlspecialchars($data['nama_user']); ?></span></div>
            <a href="<?= BASEURL; ?>/public/index.php?url=auth/logout" class="ml-auto flex-shrink-0 rounded-full bg-red-600 p-1 text-white hover:bg-red-500"><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75" /></svg></a>
        </div>
      </div>
    </div>
</nav>

<header class="bg-white shadow">
    <div class="mx-auto max-w-7xl px-4 py-6 sm:px-6 lg:px-8">
      <h1 class="text-3xl font-bold tracking-tight text-gray-900"><?= htmlspecialchars($data['title']); ?></h1>
    </div>
</header>
<main>
    <div class="mx-auto max-w-7xl py-6 sm:px-6 lg:px-8">
        
        <!-- Flash Message -->
        <?php if(isset($_SESSION['flash'])): ?>
        <div class="mb-4 rounded-md <?= $_SESSION['flash']['tipe'] == 'success' ? 'bg-green-50' : ($_SESSION['flash']['tipe'] == 'info' ? 'bg-blue-50' : 'bg-red-50') ?> p-4">
            <div class="flex">
                <div class="flex-shrink-0">
                <svg class="h-5 w-5 <?= $_SESSION['flash']['tipe'] == 'success' ? 'text-green-400' : ($_SESSION['flash']['tipe'] == 'info' ? 'text-blue-400' : 'text-red-400') ?>" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.857-9.809a.75.75 0 00-1.214-.882l-3.483 4.79-1.88-1.88a.75.75 0 10-1.06 1.061l2.5 2.5a.75.75 0 001.137-.089l4-5.5z" clip-rule="evenodd" /></svg>
                </div>
                <div class="ml-3">
                <p class="text-sm font-medium <?= $_SESSION['flash']['tipe'] == 'success' ? 'text-green-800' : ($_SESSION['flash']['tipe'] == 'info' ? 'text-blue-800' : 'text-red-800') ?>">Data Pengguna <strong><?= $_SESSION['flash']['pesan']; ?></strong> <?= $_SESSION['flash']['aksi']; ?>.</p>
                </div>
            </div>
        </div>
        <?php unset($_SESSION['flash']); endif; ?>

        <div class="bg-white p-6 rounded-lg shadow-md">
            <div class="flex justify-between items-center mb-4">
                <h2 class="text-xl font-semibold text-gray-700">Daftar Pengguna Sistem</h2>
                <button id="tombolTambahData" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded-lg">Tambah Pengguna</button>
            </div>
            
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white responsive-table">
                    <thead class="bg-gray-800 text-white">
                        <tr>
                            <th class="text-left py-3 px-4 uppercase font-semibold text-sm">No</th>
                            <th class="text-left py-3 px-4 uppercase font-semibold text-sm">Nama Lengkap</th>
                            <th class="text-left py-3 px-4 uppercase font-semibold text-sm">Username</th>
                            <th class="text-left py-3 px-4 uppercase font-semibold text-sm">Role</th>
                            <th class="text-left py-3 px-4 uppercase font-semibold text-sm">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="text-gray-700">
                        <?php $no = 1; foreach($data['users'] as $user) : ?>
                        <tr class="border-b">
                            <td class="py-3 px-4" data-label="No"><?= $no++; ?></td>
                            <td class="py-3 px-4" data-label="Nama Lengkap"><?= htmlspecialchars($user->nama_lengkap); ?></td>
                            <td class="py-3 px-4" data-label="Username"><?= htmlspecialchars($user->username); ?></td>
                            <td class="py-3 px-4" data-label="Role"><span class="capitalize rounded-full py-1 px-3 text-xs font-semibold <?= $user->role == 'admin' ? 'bg-purple-200 text-purple-800' : 'bg-teal-200 text-teal-800' ?>"><?= htmlspecialchars($user->role); ?></span></td>
                            <td class="py-3 px-4 text-center text-xs space-x-1 aksi-sel" data-label="Aksi">
                                <button data-id="<?= $user->id; ?>" class="tampilModalUbah bg-yellow-500 hover:bg-yellow-600 text-white font-bold py-1 px-2 rounded-md">Edit</button>
                                <?php if ($user->id != $_SESSION['user_id']): ?>
                                <a href="<?= BASEURL; ?>/public/index.php?url=pengguna/hapus/<?= $user->id; ?>" class="bg-red-500 hover:bg-red-600 text-white font-bold py-1 px-2 rounded-md" onclick="return confirm('Apakah Anda yakin ingin menghapus pengguna ini?');">Hapus</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Modal Form -->
<div id="formModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
  <div class="relative top-20 mx-auto p-5 border w-full max-w-lg shadow-lg rounded-md bg-white">
    <div class="mt-3 text-center">
      <h3 class="text-lg leading-6 font-medium text-gray-900" id="modalLabel">Tambah Data Pengguna</h3>
      <div class="mt-2 px-7 py-3">
        <form action="<?= BASEURL; ?>/public/index.php?url=pengguna/tambah" method="post">
            <input type="hidden" name="id" id="id">
            <div class="mb-4 text-left">
                <label for="nama_lengkap" class="block text-sm font-medium text-gray-700">Nama Lengkap</label>
                <input type="text" name="nama_lengkap" id="nama_lengkap" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" required>
            </div>
            <div class="mb-4 text-left">
                <label for="username" class="block text-sm font-medium text-gray-700">Username</label>
                <input type="text" name="username" id="username" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" required>
            </div>
             <div class="mb-4 text-left">
                <label for="role" class="block text-sm font-medium text-gray-700">Role</label>
                <select name="role" id="role" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" required>
                    <option value="admin">Admin</option>
                    <option value="bidan">Bidan</option>
                </select>
            </div>
            <div class="mb-4 text-left">
                <label for="password" class="block text-sm font-medium text-gray-700">Password</label>
                <input type="password" name="password" id="password" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                <p class="text-xs text-gray-500 mt-1" id="password-help">Kosongkan jika tidak ingin mengubah password.</p>
            </div>
             <div class="mb-4 text-left">
                <label for="confirm_password" class="block text-sm font-medium text-gray-700">Konfirmasi Password</label>
                <input type="password" name="confirm_password" id="confirm_password" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
            </div>
      </div>
      <div class="items-center px-4 py-3">
        <button id="tombolAksi" type="submit" class="px-4 py-2 bg-indigo-600 text-white text-base font-medium rounded-md w-full shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-500">Tambah Data</button>
        <button id="tombolBatal" type="button" class="mt-2 px-4 py-2 bg-gray-200 text-gray-800 text-base font-medium rounded-md w-full shadow-sm hover:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-gray-500">Batal</button>
      </div>
      </form>
    </div>
  </div>
</div>

<!-- jQuery dari CDN untuk menangani modal -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    const modal = $('#formModal');
    const modalLabel = $('#modalLabel');
    const form = modal.find('form');
    const tombolAksi = $('#tombolAksi');
    const passwordInput = $('#password');
    const confirmPasswordInput = $('#confirm_password');
    const passwordHelpText = $('#password-help');

    function resetForm() {
        form[0].reset();
        $('#id').val('');
        passwordInput.prop('required', true);
        confirmPasswordInput.prop('required', true);
        passwordHelpText.hide();
    }

    $('#tombolTambahData').on('click', function() {
        resetForm();
        form.attr('action', '<?= BASEURL; ?>/public/index.php?url=pengguna/tambah');
        modalLabel.text('Tambah Data Pengguna');
        tombolAksi.text('Tambah Data');
        passwordHelpText.text('Password wajib diisi untuk pengguna baru.');
        passwordHelpText.show();
        modal.show();
    });

    $('.tampilModalUbah').on('click', function() {
        const id = $(this).data('id');
        
        resetForm();
        modalLabel.text('Ubah Data Pengguna');
        tombolAksi.text('Ubah Data');
        form.attr('action', '<?= BASEURL; ?>/public/index.php?url=pengguna/ubah');
        
        passwordInput.prop('required', false);
        confirmPasswordInput.prop('required', false);
        passwordHelpText.text('Kosongkan jika tidak ingin mengubah password.');
        passwordHelpText.show();

        $.ajax({
            url: '<?= BASEURL; ?>/public/index.php?url=pengguna/getUbah',
            data: {id: id},
            method: 'post',
            dataType: 'json',
            success: function(data) {
                $('#id').val(data.id);
                $('#nama_lengkap').val(data.nama_lengkap);
                $('#username').val(data.username);
                $('#role').val(data.role);
            }
        });

        modal.show();
    });

    $('#tombolBatal').on('click', function() {
        modal.hide();
    });
});
</script>
<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<?php 
$this->view('layouts/footer'); 
?>
