<?php 
$this->view('layouts/header', $data); 
?>

<!-- Navigasi Bidan (sudah responsif) -->
<nav class="bg-gray-800" x-data="{ isOpen: false }">
    <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
      <div class="flex h-16 items-center justify-between">
        <div class="flex items-center">
          <div class="flex-shrink-0">
            <svg class="h-8 w-8 text-teal-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M12 21a9.004 9.004 0 008.716-6.747M12 21a9.004 9.004 0 01-8.716-6.747M12 21c2.485 0 4.5-4.03 4.5-9S14.485 3 12 3m0 18c-2.485 0-4.5-4.03-4.5-9S9.515 3 12 3m0 0a8.997 8.997 0 017.843 4.582M12 3a8.997 8.997 0 00-7.843 4.582m15.686 0A11.953 11.953 0 0112 10.5c-2.998 0-5.74-1.1-7.843-2.918m15.686 0A8.959 8.959 0 0121 12c0 .778-.099 1.533-.284 2.253m0 0A17.919 17.919 0 0112 16.5c-3.162 0-6.133-.815-8.716-2.247m0 0A9.015 9.015 0 013 12c0-1.605.42-3.113 1.157-4.418" /></svg>
          </div>
          <!-- Menu Desktop -->
          <div class="hidden md:block">
            <div class="ml-10 flex items-baseline space-x-4">
              <a href="<?= BASEURL; ?>/public/index.php?url=bidan/dashboard" class="bg-gray-900 text-white rounded-md px-3 py-2 text-sm font-medium" aria-current="page">Dashboard</a>
              
              <a href="<?= BASEURL; ?>/public/index.php?url=penilaian" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Input Penilaian</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=hasil" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Hasil Prioritas</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=jadwal" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Jadwal Kunjungan</a>
            </div>
          </div>
        </div>
        <div class="hidden md:block">
             <div class="ml-4 flex items-center md:ml-6">
                <span class="text-gray-400 text-sm mr-4">Selamat datang, <?= htmlspecialchars($data['nama_user']); ?></span>
                <a href="<?= BASEURL; ?>/public/index.php?url=auth/logout" class="rounded-full bg-red-600 p-1 text-white hover:bg-red-500 focus:outline-none"><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75" /></svg></a>
            </div>
        </div>
        <!-- Tombol Hamburger untuk Mobile -->
        <div class="-mr-2 flex md:hidden">
          <button @click="isOpen = !isOpen" type="button" class="inline-flex items-center justify-center rounded-md bg-gray-800 p-2 text-gray-400 hover:bg-gray-700 hover:text-white focus:outline-none focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-gray-800" aria-controls="mobile-menu" aria-expanded="false">
            <span class="sr-only">Buka menu</span>
            <svg :class="{'hidden': isOpen, 'block': !isOpen }" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" /></svg>
            <svg :class="{'block': isOpen, 'hidden': !isOpen }" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" /></svg>
          </button>
        </div>
      </div>
    </div>

    <!-- Panel Menu Mobile -->
    <div x-show="isOpen" class="md:hidden" id="mobile-menu">
      <div class="space-y-1 px-2 pb-3 pt-2 sm:px-3">
        <a href="<?= BASEURL; ?>/public/index.php?url=bidan/dashboard" class="bg-gray-900 text-white block rounded-md px-3 py-2 text-base font-medium" aria-current="page">Dashboard</a>
        
        <a href="<?= BASEURL; ?>/public/index.php?url=penilaian" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Input Penilaian</a>
        <a href="<?= BASEURL; ?>/public/index.php?url=hasil" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Hasil Prioritas</a>
        <a href="<?= BASEURL; ?>/public/index.php?url=jadwal" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Jadwal Kunjungan</a>
      </div>
      <div class="border-t border-gray-700 pb-3 pt-4">
        <div class="flex items-center px-5">
            <div class="flex-shrink-0">
                <span class="text-gray-400 text-sm">Selamat datang, <?= htmlspecialchars($data['nama_user']); ?></span>
            </div>
            <a href="<?= BASEURL; ?>/public/index.php?url=auth/logout" class="ml-auto flex-shrink-0 rounded-full bg-red-600 p-1 text-white hover:bg-red-500 focus:outline-none"><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75" /></svg></a>
        </div>
      </div>
    </div>
</nav>

<!-- Header dengan Gambar -->
<div class="relative bg-gray-800 pb-32">
    <div class="absolute inset-0">
        <img class="h-full w-full object-cover" src="https://images.unsplash.com/photo-1576091160550-2173dba9996a?q=80&w=2070&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D" alt="Ilustrasi Medis">
        <div class="absolute inset-0 bg-gray-800 mix-blend-multiply" aria-hidden="true"></div>
    </div>
    <div class="relative mx-auto max-w-7xl py-12 px-4 sm:px-6 lg:px-8 text-center">
        <h1 class="text-4xl font-bold tracking-tight text-white md:text-5xl lg:text-6xl">Selamat Datang, Bidan <?= htmlspecialchars($data['nama_user']); ?>!</h1>
        <p class="mt-6 max-w-3xl mx-auto text-xl text-indigo-100">Sistem siap membantu Anda menentukan prioritas kunjungan pasien hari ini.</p>
    </div>
</div>

<main class="-mt-32">
    <div class="mx-auto max-w-7xl px-4 pb-12 sm:px-6 lg:px-8">
      <div class="rounded-lg bg-white px-5 py-6 shadow sm:px-6">
        <!-- Kartu Statistik -->
        <h3 class="text-base font-semibold leading-6 text-gray-900">Ringkasan Data Anda</h3>
        <dl class="mt-5 grid grid-cols-1 gap-5 sm:grid-cols-2 lg:grid-cols-3">
          
          <div class="relative overflow-hidden rounded-lg bg-white px-4 pb-12 pt-5 shadow sm:px-6 sm:pt-6">
            <dt><div class="absolute rounded-md bg-blue-500 p-3"><svg class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 012.25-2.25h13.5A2.25 2.25 0 0121 7.5v11.25m-18 0A2.25 2.25 0 005.25 21h13.5A2.25 2.25 0 0021 18.75m-18 0v-7.5A2.25 2.25 0 015.25 9h13.5A2.25 2.25 0 0121 11.25v7.5" /></svg></div>
            <p class="ml-16 truncate text-sm font-medium text-gray-500">Jadwal Aktif</p></dt>
            <dd class="ml-16 flex items-baseline pb-6 sm:pb-7"><p class="text-2xl font-semibold text-gray-900"><?= $data['jadwal_aktif']; ?></p>
            <div class="absolute inset-x-0 bottom-0 bg-gray-50 px-4 py-4 sm:px-6"><div class="text-sm"><a href="<?= BASEURL; ?>/public/index.php?url=jadwal" class="font-medium text-blue-600 hover:text-blue-500">Lihat semua<span class="sr-only"> Jadwal Aktif stats</span></a></div></div></dd>
          </div>
          <div class="relative overflow-hidden rounded-lg bg-white px-4 pb-12 pt-5 shadow sm:px-6 sm:pt-6">
            <dt><div class="absolute rounded-md bg-green-500 p-3"><svg class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" /></svg></div>
            <p class="ml-16 truncate text-sm font-medium text-gray-500">Kunjungan Selesai</p></dt>
            <dd class="ml-16 flex items-baseline pb-6 sm:pb-7"><p class="text-2xl font-semibold text-gray-900"><?= $data['kunjungan_selesai']; ?></p>
            <div class="absolute inset-x-0 bottom-0 bg-gray-50 px-4 py-4 sm:px-6"><div class="text-sm"><a href="<?= BASEURL; ?>/public/index.php?url=jadwal" class="font-medium text-green-600 hover:text-green-500">Lihat semua<span class="sr-only"> Kunjungan Selesai stats</span></a></div></div></dd>
          </div>
        </dl>
        
        <!-- Prioritas & Jadwal -->
        <div class="mt-8 grid grid-cols-1 gap-6 lg:grid-cols-2">
            <!-- Kolom Prioritas -->
            <div>
                <h3 class="text-base font-semibold leading-6 text-gray-900">3 Pasien Prioritas Teratas</h3>
                <ul role="list" class="mt-5 divide-y divide-gray-200">
                    <?php if (empty($data['top_prioritas'])): ?>
                        <li class="py-4 text-center text-sm text-gray-500">Belum ada hasil prioritas.</li>
                    <?php else: ?>
                        <?php $ranking_map = [1 => '🥇', 2 => '🥈', 3 => '🥉']; ?>
                        <?php foreach($data['top_prioritas'] as $i => $pasien): ?>
                            <li class="flex items-center justify-between py-4">
                                <div class="flex items-center space-x-4">
                                    <span class="text-2xl"><?= $ranking_map[$i + 1] ?? '#' . ($i + 1); ?></span>
                                    <div>
                                        <p class="text-sm font-medium text-gray-900"><?= htmlspecialchars($pasien['nama_pasien']); ?></p>
                                        <p class="text-xs text-gray-500">Nilai: <?= number_format($pasien['nilai_v'], 4); ?></p>
                                    </div>
                                </div>
                                <a href="<?= BASEURL; ?>/public/index.php?url=penilaian/form/<?= $pasien['id_pasien']; ?>" class="rounded bg-white px-2 py-1 text-xs font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50">Lihat Penilaian</a>
                            </li>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </ul>
            </div>
             <!-- Kolom Aksi Cepat -->
            <div>
                <h3 class="text-base font-semibold leading-6 text-gray-900">Aksi Cepat</h3>
                <div class="mt-5 grid grid-cols-1 gap-4">
                   
                     <a href="<?= BASEURL; ?>/public/index.php?url=hasil" class="flex items-center space-x-3 rounded-lg border border-gray-300 bg-white px-6 py-5 shadow-sm hover:border-gray-400">
                        <span class="inline-flex rounded-lg bg-indigo-50 p-3 text-indigo-700 ring-4 ring-white"><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 3v11.25A2.25 2.25 0 006 16.5h12A2.25 2.25 0 0020.25 14.25V3M3.75 3v-1.5A2.25 2.25 0 016 0h12A2.25 2.25 0 0120.25 1.5v1.5M3.75 3h16.5M16.5 10.5h.008v.008H16.5v-.008z" /></svg></span>
                        <div class="min-w-0 flex-1"><p class="text-sm font-semibold text-gray-900">Lihat Hasil Prioritas</p><p class="text-sm text-gray-500">Lihat peringkat lengkap semua pasien.</p></div>
                    </a>
                </div>
            </div>
        </div>
      </div>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
<?php 
$this->view('layouts/footer'); 
?>
