<?php 
$this->view('layouts/header', $data); 
?>

<!-- Navigasi Bidan -->
<nav class="bg-gray-800" x-data="{ isOpen: false }">
    <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
      <div class="flex h-16 items-center justify-between">
        <div class="flex items-center">
          <div class="flex-shrink-0">
            <svg class="h-8 w-8 text-teal-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M12 21a9.004 9.004 0 008.716-6.747M12 21a9.004 9.004 0 01-8.716-6.747M12 21c2.485 0 4.5-4.03 4.5-9S14.485 3 12 3m0 18c-2.485 0-4.5-4.03-4.5-9S9.515 3 12 3m0 0a8.997 8.997 0 017.843 4.582M12 3a8.997 8.997 0 00-7.843 4.582m15.686 0A11.953 11.953 0 0112 10.5c-2.998 0-5.74-1.1-7.843-2.918m15.686 0A8.959 8.959 0 0121 12c0 .778-.099 1.533-.284 2.253m0 0A17.919 17.919 0 0112 16.5c-3.162 0-6.133-.815-8.716-2.247m0 0A9.015 9.015 0 013 12c0-1.605.42-3.113 1.157-4.418" /></svg>
          </div>
          <!-- Menu Desktop -->
          <div class="hidden md:block">
            <div class="ml-10 flex items-baseline space-x-4">
              <a href="<?= BASEURL; ?>/public/index.php?url=bidan/dashboard" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Dashboard</a>
              
              <a href="<?= BASEURL; ?>/public/index.php?url=penilaian" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Input Penilaian</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=hasil" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Hasil Prioritas</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=jadwal" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Jadwal Kunjungan</a>
            </div>
          </div>
        </div>
        <div class="hidden md:block">
             <div class="ml-4 flex items-center md:ml-6">
                <span class="text-gray-400 text-sm mr-4">Selamat datang, <?= htmlspecialchars($_SESSION['user_nama']); ?></span>
                <a href="<?= BASEURL; ?>/public/index.php?url=auth/logout" class="rounded-full bg-red-600 p-1 text-white hover:bg-red-500 focus:outline-none"><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75" /></svg></a>
            </div>
        </div>
        <!-- Tombol Hamburger untuk Mobile -->
        <div class="-mr-2 flex md:hidden">
          <button @click="isOpen = !isOpen" type="button" class="inline-flex items-center justify-center rounded-md bg-gray-800 p-2 text-gray-400 hover:bg-gray-700 hover:text-white focus:outline-none focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-gray-800" aria-controls="mobile-menu" aria-expanded="false">
            <span class="sr-only">Buka menu</span>
            <svg :class="{'hidden': isOpen, 'block': !isOpen }" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" /></svg>
            <svg :class="{'block': isOpen, 'hidden': !isOpen }" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" /></svg>
          </button>
        </div>
      </div>
    </div>

    <!-- Panel Menu Mobile -->
    <div x-show="isOpen" class="md:hidden" id="mobile-menu">
      <div class="space-y-1 px-2 pb-3 pt-2 sm:px-3">
        <a href="<?= BASEURL; ?>/public/index.php?url=bidan/dashboard" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Dashboard</a>
        <a href="<?= BASEURL; ?>/public/index.php?url=penilaian" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Input Penilaian</a>
        <a href="<?= BASEURL; ?>/public/index.php?url=hasil" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Hasil Prioritas</a>
        <a href="<?= BASEURL; ?>/public/index.php?url=jadwal" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Jadwal Kunjungan</a>
      </div>
      <div class="border-t border-gray-700 pb-3 pt-4">
        <div class="flex items-center px-5">
            <div class="flex-shrink-0">
                <span class="text-gray-400 text-sm">Selamat datang, <?= htmlspecialchars($_SESSION['user_nama']); ?></span>
            </div>
            <a href="<?= BASEURL; ?>/public/index.php?url=auth/logout" class="ml-auto flex-shrink-0 rounded-full bg-red-600 p-1 text-white hover:bg-red-500 focus:outline-none"><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75" /></svg></a>
        </div>
      </div>
    </div>
</nav>

<header class="bg-white shadow">
    <div class="mx-auto max-w-7xl px-4 py-6 sm:px-6 lg:px-8">
      <h1 class="text-3xl font-bold tracking-tight text-gray-900"><?= htmlspecialchars($data['title']); ?></h1>
      <p class="text-sm text-gray-500 mt-1">Perankingan berdasarkan penilaian pada tanggal: <?= date('d F Y'); ?></p>
    </div>
</header>
<main>
    <div class="mx-auto max-w-7xl py-6 sm:px-6 lg:px-8">
        <?php if (isset($data['error'])): ?>
            <div class="bg-yellow-100 border-l-4 border-yellow-500 text-yellow-700 p-4 rounded-lg" role="alert">
                <p class="font-bold">Informasi</p>
                <p><?= htmlspecialchars($data['error']); ?> Silakan lakukan penilaian terlebih dahulu di menu 'Input Penilaian'.</p>
            </div>
        <?php else: ?>
            <!-- Hasil Akhir -->
            <div class="bg-white p-6 rounded-lg shadow-md mb-6">
                <h2 class="text-2xl font-bold text-gray-800 mb-4">Peringkat Prioritas Pasien</h2>
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white">
                        <thead class="bg-teal-600 text-white">
                            <tr>
                                <th class="w-1/12 text-center py-3 px-4 uppercase font-semibold text-sm">Peringkat</th>
                                <th class="w-5/12 text-left py-3 px-4 uppercase font-semibold text-sm">Nama Pasien</th>
                                <th class="w-6/12 text-left py-3 px-4 uppercase font-semibold text-sm">Nilai Preferensi (V)</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-700">
                            <?php foreach ($data['hasil_akhir'] as $i => $hasil): ?>
                                <tr class="border-b hover:bg-teal-50 <?= $i == 0 ? 'bg-teal-100 font-bold' : '' ?>">
                                    <td class="text-center py-3 px-4"><?= $i + 1; ?></td>
                                    <td class="text-left py-3 px-4"><?= htmlspecialchars($hasil['nama_pasien']); ?></td>
                                    <td class="text-left py-3 px-4"><?= number_format($hasil['nilai_v'], 6); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Detail Perhitungan (Accordion) -->
            <div class="space-y-4">
                <div class="bg-white rounded-lg shadow-md">
                    <button class="accordion-toggle w-full px-6 py-4 text-left font-semibold text-gray-700 hover:bg-gray-50 flex justify-between items-center rounded-lg">
                        <span>Lihat Detail Perhitungan TOPSIS</span>
                        <svg class="accordion-icon w-5 h-5 transform transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                    </button>
                    <div class="accordion-content hidden p-6 overflow-x-auto border-t border-gray-200">
                        <?php $kriteria_ids = array_keys(current($data['matriks_keputusan'])); ?>
                        
                        <h3 class="font-bold text-lg mb-2">1. Matriks Keputusan (X)</h3>
                        <p class="text-sm text-gray-600 mb-4">Nilai asli dari setiap alternatif (pasien) untuk setiap kriteria.</p>
                        <table class="min-w-full text-sm mb-6 table-auto">
                            <thead class="bg-gray-200">
                                <tr>
                                    <th class="py-2 px-3">Alternatif</th>
                                    <?php foreach($kriteria_ids as $id_k) echo "<th class='py-2 px-3'>C".substr($id_k, -1)."</th>"; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($data['matriks_keputusan'] as $id_p => $nilai_k): ?>
                                <tr class="border-b">
                                    <td class="py-2 px-3 font-medium"><?= htmlspecialchars($data['nama_pasien'][$id_p]); ?></td>
                                    <?php foreach($nilai_k as $nilai) echo "<td class='py-2 px-3 text-center'>".htmlspecialchars($nilai)."</td>"; ?>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>

                        <h3 class="font-bold text-lg mb-2 mt-8">2. Matriks Normalisasi (R)</h3>
                        <p class="text-sm text-gray-600 mb-4">Setiap nilai pada matriks (X) dibagi dengan akar dari jumlah kuadrat nilai di kolomnya.</p>
                        <table class="min-w-full text-sm mb-6 table-auto">
                           <thead class="bg-gray-200">
                                <tr>
                                    <th class="py-2 px-3">Alternatif</th>
                                    <?php foreach($kriteria_ids as $id_k) echo "<th class='py-2 px-3'>C".substr($id_k, -1)."</th>"; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($data['matriks_normalisasi'] as $id_p => $nilai_k): ?>
                                <tr class="border-b">
                                    <td class="py-2 px-3 font-medium"><?= htmlspecialchars($data['nama_pasien'][$id_p]); ?></td>
                                    <?php foreach($nilai_k as $nilai) echo "<td class='py-2 px-3 text-center'>".number_format($nilai, 4)."</td>"; ?>
                                </tr>
                                <?php endforeach; ?>
                                <tr class="bg-gray-100 font-bold">
                                    <td class="py-2 px-3">Pembagi</td>
                                    <?php foreach($data['pembagi'] as $nilai) echo "<td class='py-2 px-3 text-center'>".number_format($nilai, 4)."</td>"; ?>
                                </tr>
                            </tbody>
                        </table>

                        <h3 class="font-bold text-lg mb-2 mt-8">3. Matriks Normalisasi Terbobot (Y)</h3>
                        <p class="text-sm text-gray-600 mb-4">Setiap nilai pada matriks normalisasi (R) dikalikan dengan bobot kriterianya.</p>
                        <table class="min-w-full text-sm mb-6 table-auto">
                           <thead class="bg-gray-200">
                                <tr>
                                    <th class="py-2 px-3">Alternatif</th>
                                    <?php foreach($kriteria_ids as $id_k) echo "<th class='py-2 px-3'>C".substr($id_k, -1)."</th>"; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($data['matriks_terbobot'] as $id_p => $nilai_k): ?>
                                <tr class="border-b">
                                    <td class="py-2 px-3 font-medium"><?= htmlspecialchars($data['nama_pasien'][$id_p]); ?></td>
                                    <?php foreach($nilai_k as $nilai) echo "<td class='py-2 px-3 text-center'>".number_format($nilai, 4)."</td>"; ?>
                                </tr>
                                <?php endforeach; ?>
                                <tr class="bg-gray-100 font-bold">
                                    <td class="py-2 px-3">Bobot</td>
                                    <?php foreach($data['bobot'] as $nilai) echo "<td class='py-2 px-3 text-center'>".htmlspecialchars($nilai)."</td>"; ?>
                                </tr>
                            </tbody>
                        </table>

                        <h3 class="font-bold text-lg mb-2 mt-8">4. Solusi Ideal (A+ dan A-)</h3>
                        <p class="text-sm text-gray-600 mb-4">Nilai terbaik (A+) dan terburuk (A-) dari setiap kriteria pada matriks terbobot. Ingat, untuk tipe 'cost', nilai terkecil adalah yang terbaik.</p>
                        <table class="min-w-full text-sm mb-6 table-auto">
                           <thead class="bg-gray-200">
                                <tr>
                                    <th class="py-2 px-3">Kriteria</th>
                                    <?php foreach($kriteria_ids as $id_k) echo "<th class='py-2 px-3'>C".substr($id_k, -1)."</th>"; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="border-b bg-green-50">
                                    <td class="py-2 px-3 font-medium">A+ (Ideal Positif)</td>
                                    <?php foreach($data['solusi_ideal_positif'] as $nilai) echo "<td class='py-2 px-3 text-center'>".number_format($nilai, 4)."</td>"; ?>
                                </tr>
                                <tr class="border-b bg-red-50">
                                    <td class="py-2 px-3 font-medium">A- (Ideal Negatif)</td>
                                    <?php foreach($data['solusi_ideal_negatif'] as $nilai) echo "<td class='py-2 px-3 text-center'>".number_format($nilai, 4)."</td>"; ?>
                                </tr>
                            </tbody>
                        </table>

                         <h3 class="font-bold text-lg mb-2 mt-8">5. Jarak ke Solusi Ideal (D+ dan D-)</h3>
                         <p class="text-sm text-gray-600 mb-4">Menghitung jarak setiap alternatif ke solusi ideal positif (D+) dan negatif (D-).</p>
                        <table class="min-w-full text-sm table-auto">
                           <thead class="bg-gray-200">
                                <tr>
                                    <th class="py-2 px-3">Alternatif</th>
                                    <th class="py-2 px-3 text-center">Jarak Positif (D+)</th>
                                    <th class="py-2 px-3 text-center">Jarak Negatif (D-)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($data['jarak_positif'] as $id_p => $d_plus): ?>
                                <tr class="border-b">
                                    <td class="py-2 px-3 font-medium"><?= htmlspecialchars($data['nama_pasien'][$id_p]); ?></td>
                                    <td class="py-2 px-3 text-center"><?= number_format($d_plus, 4); ?></td>
                                    <td class="py-2 px-3 text-center"><?= number_format($data['jarak_negatif'][$id_p], 4); ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>

                        <!-- Bagian Kesimpulan Baru -->
                        <h3 class="font-bold text-lg mb-2 mt-8">6. Kesimpulan dan Nilai Preferensi (V)</h3>
                        <p class="text-sm text-gray-600 mb-4">
                            Langkah terakhir adalah menghitung nilai preferensi (V) untuk setiap alternatif dengan rumus V = D- / (D+ + D-). Alternatif dengan nilai V terbesar menjadi peringkat pertama karena dianggap paling dekat dengan solusi ideal positif dan paling jauh dari solusi ideal negatif.
                        </p>
                        <table class="min-w-full text-sm table-auto">
                            <thead class="bg-gray-200">
                                <tr>
                                    <th class="py-2 px-3">Alternatif</th>
                                    <th class="py-2 px-3 text-center">D-</th>
                                    <th class="py-2 px-3 text-center">D+</th>
                                    <th class="py-2 px-3 text-center">Hasil (V)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($data['hasil_akhir'] as $hasil): ?>
                                <tr class="border-b">
                                    <td class="py-2 px-3 font-medium"><?= htmlspecialchars($hasil['nama_pasien']); ?></td>
                                    <td class="py-2 px-3 text-center"><?= number_format($data['jarak_negatif'][$hasil['id_pasien']], 4); ?></td>
                                    <td class="py-2 px-3 text-center"><?= number_format($data['jarak_positif'][$hasil['id_pasien']], 4); ?></td>
                                    <td class="py-2 px-3 text-center font-bold text-teal-700"><?= number_format($hasil['nilai_v'], 6); ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>

        <?php endif; ?>
    </div>
</main>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const accordions = document.querySelectorAll('.accordion-toggle');
    accordions.forEach(button => {
        button.addEventListener('click', () => {
            const content = button.nextElementSibling;
            const icon = button.querySelector('.accordion-icon');
            
            content.classList.toggle('hidden');
            icon.classList.toggle('rotate-180');
        });
    });
});
</script>
<script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

<?php 
$this->view('layouts/footer'); 
?>
