<?php 
$this->view('layouts/header', $data); 
?>
<style>
  @media (max-width: 767px) {
    .responsive-table thead {display: none;}
    .responsive-table tr {display: block; margin-bottom: 1rem; border-radius: 0.5rem; overflow: hidden; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);}
    .responsive-table td {display: block; text-align: right; padding-left: 50%; position: relative; border-bottom: 1px solid #edf2f7;}
    .responsive-table td::before {content: attr(data-label); position: absolute; left: 0.75rem; font-weight: 600; text-align: left;}
    .responsive-table td:last-child {border-bottom: 0;}
    .responsive-table .aksi-sel {padding-left: 0; text-align: center; padding-top: 0.75rem; padding-bottom: 0.75rem; background-color: #f9fafb;}
    .responsive-table .aksi-sel::before {content: '';}
  }
</style>
<!-- Navigasi Bidan -->
<nav class="bg-gray-800" x-data="{ isOpen: false }">
    <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
      <div class="flex h-16 items-center justify-between">
        <div class="flex items-center">
          <div class="flex-shrink-0">
            <svg class="h-8 w-8 text-teal-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M12 21a9.004 9.004 0 008.716-6.747M12 21a9.004 9.004 0 01-8.716-6.747M12 21c2.485 0 4.5-4.03 4.5-9S14.485 3 12 3m0 18c-2.485 0-4.5-4.03-4.5-9S9.515 3 12 3m0 0a8.997 8.997 0 017.843 4.582M12 3a8.997 8.997 0 00-7.843 4.582m15.686 0A11.953 11.953 0 0112 10.5c-2.998 0-5.74-1.1-7.843-2.918m15.686 0A8.959 8.959 0 0121 12c0 .778-.099 1.533-.284 2.253m0 0A17.919 17.919 0 0112 16.5c-3.162 0-6.133-.815-8.716-2.247m0 0A9.015 9.015 0 013 12c0-1.605.42-3.113 1.157-4.418" /></svg>
          </div>
          <!-- Menu Desktop -->
          <div class="hidden md:block">
            <div class="ml-10 flex items-baseline space-x-4">
              <a href="<?= BASEURL; ?>/public/index.php?url=bidan/dashboard" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Dashboard</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=pasien" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Data Pasien</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=penilaian" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Input Penilaian</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=hasil" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Hasil Prioritas</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=jadwal" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Jadwal Kunjungan</a>
            </div>
          </div>
        </div>
        <div class="hidden md:block">
             <div class="ml-4 flex items-center md:ml-6">
                <span class="text-gray-400 text-sm mr-4">Selamat datang, <?= htmlspecialchars($_SESSION['user_nama']); ?></span>
                <a href="<?= BASEURL; ?>/public/index.php?url=auth/logout" class="rounded-full bg-red-600 p-1 text-white hover:bg-red-500 focus:outline-none"><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75" /></svg></a>
            </div>
        </div>
        <!-- Tombol Hamburger untuk Mobile -->
        <div class="-mr-2 flex md:hidden">
          <button @click="isOpen = !isOpen" type="button" class="inline-flex items-center justify-center rounded-md bg-gray-800 p-2 text-gray-400 hover:bg-gray-700 hover:text-white focus:outline-none focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-gray-800" aria-controls="mobile-menu" aria-expanded="false">
            <span class="sr-only">Buka menu</span>
            <svg :class="{'hidden': isOpen, 'block': !isOpen }" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" /></svg>
            <svg :class="{'block': isOpen, 'hidden': !isOpen }" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" /></svg>
          </button>
        </div>
      </div>
    </div>

    <!-- Panel Menu Mobile -->
    <div x-show="isOpen" class="md:hidden" id="mobile-menu">
      <div class="space-y-1 px-2 pb-3 pt-2 sm:px-3">
        <a href="<?= BASEURL; ?>/public/index.php?url=bidan/dashboard" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Dashboard</a>
        <a href="<?= BASEURL; ?>/public/index.php?url=pasien" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Data Pasien</a>
        <a href="<?= BASEURL; ?>/public/index.php?url=penilaian" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Input Penilaian</a>
        <a href="<?= BASEURL; ?>/public/index.php?url=hasil" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Hasil Prioritas</a>
        <a href="<?= BASEURL; ?>/public/index.php?url=jadwal" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Jadwal Kunjungan</a>
      </div>
      <div class="border-t border-gray-700 pb-3 pt-4">
        <div class="flex items-center px-5">
            <div class="flex-shrink-0">
                <span class="text-gray-400 text-sm">Selamat datang, <?= htmlspecialchars($_SESSION['user_nama']); ?></span>
            </div>
            <a href="<?= BASEURL; ?>/public/index.php?url=auth/logout" class="ml-auto flex-shrink-0 rounded-full bg-red-600 p-1 text-white hover:bg-red-500 focus:outline-none"><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75" /></svg></a>
        </div>
      </div>
    </div>
</nav>

<header class="bg-white shadow">
    <div class="mx-auto max-w-7xl px-4 py-6 sm:px-6 lg:px-8">
      <h1 class="text-3xl font-bold tracking-tight text-gray-900"><?= htmlspecialchars($data['title']); ?></h1>
    </div>
</header>
<main>
    <div class="mx-auto max-w-7xl py-6 sm:px-6 lg:px-8">
        
        <!-- Flash Message -->
        <?php if(isset($_SESSION['flash'])): ?>
        <div class="mb-4 rounded-md <?= $_SESSION['flash']['tipe'] == 'success' ? 'bg-green-50' : ($_SESSION['flash']['tipe'] == 'info' ? 'bg-blue-50' : 'bg-red-50') ?> p-4">
            <div class="flex">
                <div class="flex-shrink-0">
                <svg class="h-5 w-5 <?= $_SESSION['flash']['tipe'] == 'success' ? 'text-green-400' : ($_SESSION['flash']['tipe'] == 'info' ? 'text-blue-400' : 'text-red-400') ?>" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.857-9.809a.75.75 0 00-1.214-.882l-3.483 4.79-1.88-1.88a.75.75 0 10-1.06 1.061l2.5 2.5a.75.75 0 001.137-.089l4-5.5z" clip-rule="evenodd" /></svg>
                </div>
                <div class="ml-3">
                <p class="text-sm font-medium <?= $_SESSION['flash']['tipe'] == 'success' ? 'text-green-800' : ($_SESSION['flash']['tipe'] == 'info' ? 'text-blue-800' : 'text-red-800') ?>">Data Pasien <strong><?= $_SESSION['flash']['pesan']; ?></strong> <?= $_SESSION['flash']['aksi']; ?>.</p>
                </div>
            </div>
        </div>
        <?php unset($_SESSION['flash']); endif; ?>

        <div class="bg-white p-6 rounded-lg shadow-md">
            <div class="flex justify-between items-center mb-4">
                <h2 class="text-xl font-semibold text-gray-700">Daftar Pasien Ibu Hamil</h2>
                <button id="tombolTambahData" class="bg-teal-600 hover:bg-teal-700 text-white font-bold py-2 px-4 rounded-lg">Tambah Pasien</button>
            </div>
            
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white responsive-table">
                    <thead class="bg-gray-800 text-white">
                        <tr>
                            <th class="text-left py-3 px-4 uppercase font-semibold text-sm">No</th>
                            <th class="text-left py-3 px-4 uppercase font-semibold text-sm">Nama Ibu</th>
                            <th class="text-left py-3 px-4 uppercase font-semibold text-sm">NIK</th>
                            <th class="text-left py-3 px-4 uppercase font-semibold text-sm">Alamat</th>
                            <th class="text-left py-3 px-4 uppercase font-semibold text-sm">Usia Kehamilan</th>
                            <th class="text-left py-3 px-4 uppercase font-semibold text-sm">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="text-gray-700">
                        <?php if (empty($data['pasien'])): ?>
                            <tr>
                                <td colspan="6" class="text-center py-5">Belum ada data pasien.</td>
                            </tr>
                        <?php else: ?>
                            <?php $no = 1; foreach($data['pasien'] as $pasien) : ?>
                            <tr class="border-b">
                                <td class="py-3 px-4" data-label="No"><?= $no++; ?></td>
                                <td class="py-3 px-4" data-label="Nama Ibu"><?= htmlspecialchars($pasien->nama_ibu); ?></td>
                                <td class="py-3 px-4" data-label="NIK"><?= htmlspecialchars($pasien->nik); ?></td>
                                <td class="py-3 px-4" data-label="Alamat"><?= htmlspecialchars($pasien->alamat); ?></td>
                                <td class="py-3 px-4" data-label="Usia Kehamilan"><?= htmlspecialchars($pasien->usia_kehamilan_minggu); ?> minggu</td>
                                <td class="py-3 px-4">
                                    <button data-id="<?= $pasien->id; ?>" class="tampilModalUbah bg-yellow-500 hover:bg-yellow-600 text-white font-bold py-1 px-2 rounded-md text-xs">Edit</button>
                                    <a href="<?= BASEURL; ?>/public/index.php?url=pasien/hapus/<?= $pasien->id; ?>" class="bg-red-500 hover:bg-red-600 text-white font-bold py-1 px-2 rounded-md text-xs" onclick="return confirm('Apakah Anda yakin ingin menghapus data pasien ini?');">Hapus</a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Modal Form -->
<div id="formModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
  <div class="relative top-5 mx-auto p-5 border w-full max-w-2xl shadow-lg rounded-md bg-white">
    <div class="mt-3">
      <h3 class="text-lg leading-6 font-medium text-gray-900 text-center" id="modalLabel">Tambah Data Pasien</h3>
      <div class="mt-2 px-7 py-3">
        <form action="<?= BASEURL; ?>/public/index.php?url=pasien/tambah" method="post">
            <input type="hidden" name="id" id="id">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="mb-4 text-left">
                    <label for="nama_ibu" class="block text-sm font-medium text-gray-700">Nama Ibu</label>
                    <input type="text" name="nama_ibu" id="nama_ibu" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div class="mb-4 text-left">
                    <label for="nik" class="block text-sm font-medium text-gray-700">NIK</label>
                    <input type="text" name="nik" id="nik" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
                <div class="mb-4 text-left">
                    <label for="tanggal_lahir" class="block text-sm font-medium text-gray-700">Tanggal Lahir</label>
                    <input type="date" name="tanggal_lahir" id="tanggal_lahir" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
                <div class="mb-4 text-left">
                    <label for="no_telepon" class="block text-sm font-medium text-gray-700">No. Telepon</label>
                    <input type="tel" name="no_telepon" id="no_telepon" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
                <div class="mb-4 text-left md:col-span-2">
                    <label for="alamat" class="block text-sm font-medium text-gray-700">Alamat</label>
                    <textarea name="alamat" id="alamat" rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></textarea>
                </div>
                <div class="mb-4 text-left md:col-span-2">
                    <label for="usia_kehamilan_minggu" class="block text-sm font-medium text-gray-700">Usia Kehamilan (dalam minggu)</label>
                    <input type="number" name="usia_kehamilan_minggu" id="usia_kehamilan_minggu" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
            </div>
      </div>
      <div class="items-center px-4 py-3 bg-gray-50 rounded-b-md">
        <button id="tombolAksi" type="submit" class="px-4 py-2 bg-teal-600 text-white text-base font-medium rounded-md w-full shadow-sm hover:bg-teal-700">Tambah Data</button>
        <button id="tombolBatal" type="button" class="mt-2 px-4 py-2 bg-gray-200 text-gray-800 text-base font-medium rounded-md w-full shadow-sm hover:bg-gray-300">Batal</button>
      </div>
      </form>
    </div>
  </div>
</div>

<!-- jQuery dari CDN untuk menangani modal -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    const modal = $('#formModal');
    const modalLabel = $('#modalLabel');
    const form = modal.find('form');
    const tombolAksi = $('#tombolAksi');

    // Buka modal untuk tambah data
    $('#tombolTambahData').on('click', function() {
        form.attr('action', '<?= BASEURL; ?>/public/index.php?url=pasien/tambah');
        modalLabel.text('Tambah Data Pasien');
        tombolAksi.text('Tambah Data');
        form[0].reset(); 
        $('#id').val('');
        modal.show();
    });

    // Buka modal untuk ubah data
    $('.tampilModalUbah').on('click', function() {
        const id = $(this).data('id');
        
        modalLabel.text('Ubah Data Pasien');
        tombolAksi.text('Ubah Data');
        form.attr('action', '<?= BASEURL; ?>/public/index.php?url=pasien/ubah');

        $.ajax({
            url: '<?= BASEURL; ?>/public/index.php?url=pasien/getUbah',
            data: {id: id},
            method: 'post',
            dataType: 'json',
            success: function(data) {
                $('#id').val(data.id);
                $('#nama_ibu').val(data.nama_ibu);
                $('#nik').val(data.nik);
                $('#alamat').val(data.alamat);
                $('#no_telepon').val(data.no_telepon);
                $('#tanggal_lahir').val(data.tanggal_lahir);
                $('#usia_kehamilan_minggu').val(data.usia_kehamilan_minggu);
            }
        });

        modal.show();
    });

    // Tombol batal untuk menutup modal
    $('#tombolBatal').on('click', function() {
        modal.hide();
    });
});
</script>
<script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
<?php 
$this->view('layouts/footer'); 
?>
