<?php 
$this->view('layouts/header', $data); 
?>

<!-- Navigasi Bidan -->
<nav class="bg-gray-800" x-data="{ isOpen: false }">
    <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
      <div class="flex h-16 items-center justify-between">
        <div class="flex items-center">
          <div class="flex-shrink-0">
            <svg class="h-8 w-8 text-teal-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M12 21a9.004 9.004 0 008.716-6.747M12 21a9.004 9.004 0 01-8.716-6.747M12 21c2.485 0 4.5-4.03 4.5-9S14.485 3 12 3m0 18c-2.485 0-4.5-4.03-4.5-9S9.515 3 12 3m0 0a8.997 8.997 0 017.843 4.582M12 3a8.997 8.997 0 00-7.843 4.582m15.686 0A11.953 11.953 0 0112 10.5c-2.998 0-5.74-1.1-7.843-2.918m15.686 0A8.959 8.959 0 0121 12c0 .778-.099 1.533-.284 2.253m0 0A17.919 17.919 0 0112 16.5c-3.162 0-6.133-.815-8.716-2.247m0 0A9.015 9.015 0 013 12c0-1.605.42-3.113 1.157-4.418" /></svg>
          </div>
          <!-- Menu Desktop -->
          <div class="hidden md:block">
            <div class="ml-10 flex items-baseline space-x-4">
              <a href="<?= BASEURL; ?>/public/index.php?url=bidan/dashboard" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Dashboard</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=pasien" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Data Pasien</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=penilaian" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Input Penilaian</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=hasil" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Hasil Prioritas</a>
              <a href="<?= BASEURL; ?>/public/index.php?url=jadwal" class="text-gray-300 hover:bg-gray-700 hover:text-white rounded-md px-3 py-2 text-sm font-medium">Jadwal Kunjungan</a>
            </div>
          </div>
        </div>
        <div class="hidden md:block">
             <div class="ml-4 flex items-center md:ml-6">
                <span class="text-gray-400 text-sm mr-4">Selamat datang, <?= htmlspecialchars($_SESSION['user_nama']); ?></span>
                <a href="<?= BASEURL; ?>/public/index.php?url=auth/logout" class="rounded-full bg-red-600 p-1 text-white hover:bg-red-500 focus:outline-none"><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75" /></svg></a>
            </div>
        </div>
        <!-- Tombol Hamburger untuk Mobile -->
        <div class="-mr-2 flex md:hidden">
          <button @click="isOpen = !isOpen" type="button" class="inline-flex items-center justify-center rounded-md bg-gray-800 p-2 text-gray-400 hover:bg-gray-700 hover:text-white focus:outline-none focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-gray-800" aria-controls="mobile-menu" aria-expanded="false">
            <span class="sr-only">Buka menu</span>
            <svg :class="{'hidden': isOpen, 'block': !isOpen }" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" /></svg>
            <svg :class="{'block': isOpen, 'hidden': !isOpen }" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" /></svg>
          </button>
        </div>
      </div>
    </div>

    <!-- Panel Menu Mobile -->
    <div x-show="isOpen" class="md:hidden" id="mobile-menu">
      <div class="space-y-1 px-2 pb-3 pt-2 sm:px-3">
        <a href="<?= BASEURL; ?>/public/index.php?url=bidan/dashboard" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Dashboard</a>
        <a href="<?= BASEURL; ?>/public/index.php?url=pasien" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Data Pasien</a>
        <a href="<?= BASEURL; ?>/public/index.php?url=penilaian" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Input Penilaian</a>
        <a href="<?= BASEURL; ?>/public/index.php?url=hasil" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Hasil Prioritas</a>
        <a href="<?= BASEURL; ?>/public/index.php?url=jadwal" class="text-gray-300 hover:bg-gray-700 hover:text-white block rounded-md px-3 py-2 text-base font-medium">Jadwal Kunjungan</a>
      </div>
      <div class="border-t border-gray-700 pb-3 pt-4">
        <div class="flex items-center px-5">
            <div class="flex-shrink-0">
                <span class="text-gray-400 text-sm">Selamat datang, <?= htmlspecialchars($_SESSION['user_nama']); ?></span>
            </div>
            <a href="<?= BASEURL; ?>/public/index.php?url=auth/logout" class="ml-auto flex-shrink-0 rounded-full bg-red-600 p-1 text-white hover:bg-red-500 focus:outline-none"><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75" /></svg></a>
        </div>
      </div>
    </div>
</nav>

<header class="bg-white shadow">
    <div class="mx-auto max-w-7xl px-4 py-6 sm:px-6 lg:px-8">
      <h1 class="text-3xl font-bold tracking-tight text-gray-900"><?= htmlspecialchars($data['title']); ?></h1>
    </div>
</header>
<main>
    <div class="mx-auto max-w-3xl py-6 sm:px-6 lg:px-8">
        <div class="bg-white p-6 rounded-lg shadow-md">
            <div class="border-b border-gray-200 pb-4 mb-4">
                <h2 class="text-xl font-semibold text-gray-800">Pasien: <span class="text-teal-600"><?= htmlspecialchars($data['pasien']->nama_ibu); ?></span></h2>
                <p class="text-sm text-gray-500">NIK: <?= htmlspecialchars($data['pasien']->nik); ?></p>
            </div>
            
            <form action="<?= BASEURL; ?>/public/index.php?url=penilaian/simpan" method="POST">
                <input type="hidden" name="id_pasien" value="<?= $data['pasien']->id; ?>">
                
                <div class="space-y-6">
                    <?php foreach ($data['kriteria_list'] as $kriteria): ?>
                    <div>
                        <label for="kriteria_<?= $kriteria['id_kriteria']; ?>" class="block text-md font-medium text-gray-700">
                            <?= htmlspecialchars($kriteria['kode_kriteria']); ?> - <?= htmlspecialchars($kriteria['nama_kriteria']); ?>
                        </label>
                        <select id="kriteria_<?= $kriteria['id_kriteria']; ?>" name="penilaian[<?= $kriteria['id_kriteria']; ?>]" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-teal-500 focus:border-teal-500 sm:text-sm rounded-md" required>
                            <option value="">-- Pilih Nilai --</option>
                            <?php foreach ($kriteria['sub_kriteria'] as $sub): ?>
                                <?php
                                    // Cek apakah ada penilaian terakhir dan cocok dengan sub-kriteria ini
                                    $selected = '';
                                    if (isset($data['penilaian_terakhir'][$kriteria['id_kriteria']]) && $data['penilaian_terakhir'][$kriteria['id_kriteria']] == $sub['id_sub_kriteria']) {
                                        $selected = 'selected';
                                    }
                                ?>
                                <option value="<?= $sub['id_sub_kriteria']; ?>" <?= $selected; ?>>
                                    <?= htmlspecialchars($sub['deskripsi']); ?> (Nilai: <?= $sub['nilai']; ?>)
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <?php endforeach; ?>
                </div>

                <div class="mt-8 pt-5 border-t border-gray-200">
                    <div class="flex justify-end space-x-3">
                        <a href="<?= BASEURL; ?>/public/index.php?url=penilaian" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-2 px-4 rounded-lg">Batal</a>
                        <button type="submit" class="bg-teal-600 hover:bg-teal-700 text-white font-bold py-2 px-4 rounded-lg">Simpan Penilaian</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</main>
<script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
<?php 
$this->view('layouts/footer'); 
?>
